import { BrowserOptions } from '@sentry/browser';
import { Integration } from '@sentry/core';
/** Get the default integrations for the renderer SDK. */
export declare function getDefaultIntegrations(options: ElectronRendererOptions): Integration[];
export interface ElectronRendererOptionsInternal extends Omit<BrowserOptions, 'dsn' | 'environment' | 'release'> {
    /** @deprecated `dsn` should only be passed to the main process `Sentry.init` call */
    dsn?: string;
    /** @deprecated `release` should only be passed to the main process `Sentry.init` call */
    release?: string;
    /** @deprecated `environment` should only be passed to the main process `Sentry.init` call */
    environment?: string;
    /**
     * Custom namespace for IPC channels and protocol routes.
     *
     * Valid characters are a-z, 0-9, hyphen (-).
     * Should match `ipcNamespace` passed in the main process.
     *
     * @default "sentry-ipc"
     */
    ipcNamespace: string;
}
interface ElectronRendererOptions extends Partial<ElectronRendererOptionsInternal> {
}
/**
 * Initialize Sentry in the Electron renderer process
 * @param options SDK options
 * @param originalInit Optional init function for a specific framework SDK
 * @returns
 */
export declare function init<O extends ElectronRendererOptions>(options?: ElectronRendererOptions & O, originalInit?: (if_you_get_a_typescript_error_ensure_sdks_use_version_v10_11_0: O) => void): void;
export {};
//# sourceMappingURL=sdk.d.ts.map