import { Integration } from '@sentry/core';
import { disableBlockDetectionForCallback, eventLoopBlockIntegration as nodeEventLoopBlockIntegration, pauseEventLoopBlockDetection, restartEventLoopBlockDetection } from '@sentry/node-native';
type Options = Parameters<typeof nodeEventLoopBlockIntegration>[0];
/**
 * > **Note**
 * >
 * > You should add `@sentry/node-native` to your dependencies to use this integration.
 *
 * Monitors the Node.js event loop for blocking behavior and reports blocked events to Sentry.
 *
 * Uses a background worker and native module to detect when the main thread is blocked for longer than the configured
 * threshold (default: 1 second). When a block is detected, it captures an event with stack traces for every thread.
 *
 * ```js
 * import * as Sentry from '@sentry/electron/main';
 * import { eventLoopBlockIntegration } from '@sentry/electron/native';
 *
 * Sentry.init({
 *   dsn: '__YOUR_DSN__',
 *   integrations: [
 *     eventLoopBlockIntegration({
 *       threshold: 500, // Report blocks longer than 500ms
 *     }),
 *   ],
 * });
 * ```
 */
export declare const eventLoopBlockIntegration: (options: Options) => Integration;
export { disableBlockDetectionForCallback, pauseEventLoopBlockDetection, restartEventLoopBlockDetection };
//# sourceMappingURL=event-loop-blocked-integration.d.ts.map