import { BaseTransportOptions, OfflineTransportOptions, Transport } from '@sentry/core';
import { ElectronNetTransportOptions } from './electron-net.js';
import { OfflineStoreOptions } from './offline-store.js';
export type ElectronOfflineTransportOptions = ElectronNetTransportOptions & OfflineTransportOptions & Partial<OfflineStoreOptions>;
/**
 * Creates a Transport that uses Electrons net module to send events to Sentry. When they fail to send they are
 * persisted to disk and sent later
 */
export declare function makeElectronOfflineTransport<T extends BaseTransportOptions>(baseTransport?: (opt: T & ElectronOfflineTransportOptions) => Transport): (options: T & ElectronOfflineTransportOptions) => Transport;
//# sourceMappingURL=electron-offline-net.d.ts.map