/// <reference types="node" />
/// <reference types="node" />
export declare const MINIDUMP_MAGIC_SIGNATURE = "MDMP";
type MinidumpHeader = {
    /** This should be MDMP */
    signature: string;
    /** This should be 42899 */
    version: number;
    /** The number of streams contained in the stream directory. */
    streamCount: number;
    /**
     * The offset to the stream directory within the minidump.
     * This usually points to immediately after the header.
     * The stream directory is an array containing `stream_count`
     */
    streamDirectoryRva: number;
    checksum: number;
    timeDateStamp: Date;
    flags: bigint;
};
type CrashpadAnnotations = {
    process_type?: string;
} & Record<string, string>;
export type MinidumpParseResult = {
    header: MinidumpHeader;
    crashpadAnnotations?: CrashpadAnnotations;
};
/**
 * Parses an Electron minidump and extracts the header and crashpad annotations
 */
export declare function parseMinidump(buf: Buffer): MinidumpParseResult;
export {};
//# sourceMappingURL=minidump-parser.d.ts.map