type ShouldTraceFn = (method: string, url: string) => boolean;
export interface NetOptions {
    /**
     * Whether breadcrumbs should be captured for net requests
     *
     * Defaults to: true
     */
    breadcrumbs?: boolean;
    /**
     * Whether to capture transaction spans for net requests
     *
     * true | false | (method: string, url: string) => boolean
     * Defaults to: true
     */
    tracing?: ShouldTraceFn | boolean;
}
/**
 * Electron 'net' module integration
 */
export declare const electronNetIntegration: (options?: NetOptions | undefined) => import("@sentry/core").Integration;
export {};
//# sourceMappingURL=net-breadcrumbs.d.ts.map