import { childProcessIntegration as nodeChildProcessIntegration } from '@sentry/node';
import { ExitReason } from '../electron-normalize.js';
type NodeChildProcessOptions = NonNullable<Parameters<typeof nodeChildProcessIntegration>[0]>;
type OrBool<T> = {
    [P in keyof T]: T[P] | boolean;
};
export interface ChildProcessOptions extends NodeChildProcessOptions {
    /** Child process events that generate breadcrumbs */
    breadcrumbs: Readonly<ExitReason[]>;
    /** Child process events that generate Sentry events */
    events: Readonly<ExitReason[]>;
}
/**
 * Adds breadcrumbs for:
 * - Electron child process events
 * - Node `child_process` events
 * - Node `worker_threads` events
 */
export declare const childProcessIntegration: (userOptions?: Partial<OrBool<ChildProcessOptions>> | undefined) => import("@sentry/core").Integration;
export {};
//# sourceMappingURL=child-process.d.ts.map