/// <reference types="node" />
/// <reference types="node" />
import { Session } from 'electron';
export declare const ELECTRON_MAJOR_VERSION: number;
export declare const EXIT_REASONS: readonly ["clean-exit", "abnormal-exit", "killed", "crashed", "oom", "launch-failed", "integrity-failure"];
export type ExitReason = (typeof EXIT_REASONS)[number];
export declare const CRASH_REASONS: Readonly<ExitReason[]>;
/** Gets the Sentry Cache path */
export declare function getSentryCachePath(): string;
interface InternalRequest {
    windowId?: string;
    url: string;
    body?: Buffer;
}
/**
 * Registers a custom protocol to receive events from the renderer
 *
 * Uses `protocol.handle` if available, otherwise falls back to `protocol.registerStringProtocol`
 */
export declare function registerProtocol(protocol: Electron.Protocol, scheme: string, callback: (request: InternalRequest) => void): void;
type PreloadScriptRegistration = {
    type: 'frame' | 'service-worker';
    id?: string;
    filePath: string;
};
type SessionMaybeSupportingRegisterPreloadScript = Session & {
    registerPreloadScript?: (script: PreloadScriptRegistration) => void;
};
/**
 * Adds a preload script to the session.
 *
 * Electron >= v35 supports new `registerPreloadScript` method and `getPreloads` and `setPreloads` are deprecated.
 */
export declare function setPreload(sesh: SessionMaybeSupportingRegisterPreloadScript, path: string): void;
export {};
//# sourceMappingURL=electron-normalize.d.ts.map