import { OfflineStore } from '@sentry/core';
export interface OfflineStoreOptions {
    /**
     * Path to the offline queue directory.
     */
    queuePath: string;
    /**
     * Maximum number of days to store requests.
     */
    maxAgeDays: number;
    /**
     * Maximum number of requests to store.
     */
    maxQueueSize: number;
}
/**
 * Creates a new offline store.
 */
export declare function createOfflineStore(userOptions: Partial<OfflineStoreOptions>): OfflineStore;
//# sourceMappingURL=offline-store.d.ts.map