import { StackFrame, StackParser } from '@sentry/core';
import { WebContents } from 'electron';
export declare const defaultStackParser: StackParser;
/**
 * Captures stack frames from a renderer process
 *
 * Requires Electron >= 34 and throws an error on older versions
 *
 * @param webContents The WebContents to capture stack frames from
 * @returns A promise that resolves to an array of Sentry StackFrames
 */
export declare function captureRendererStackFrames(webContents: WebContents): Promise<StackFrame[] | undefined>;
//# sourceMappingURL=stack-parse.d.ts.map