import { Integration, Options } from '@sentry/core';
import { NodeOptions } from '@sentry/node';
import { Session, WebContents } from 'electron';
import { IPCMode } from '../common/ipc.js';
import { ElectronOfflineTransportOptions } from './transports/electron-offline-net.js';
/** Get the default integrations for the main process SDK. */
export declare function getDefaultIntegrations(options: ElectronMainOptions): Integration[];
export interface ElectronMainOptionsInternal extends Options<ElectronOfflineTransportOptions>, Omit<NodeOptions, 'transport' | 'transportOptions'> {
    /**
     * Inter-process communication mode to receive event and scope from renderers
     *
     * IPCMode.Classic - Configures Electron IPC
     * IPCMode.Protocol - Configures a custom protocol
     * IPCMode.Both - Configures both IPC and custom protocol
     *
     * defaults to IPCMode.Both for maximum compatibility
     */
    ipcMode: IPCMode;
    /**
     * Custom namespace for IPC channels and protocol routes.
     *
     * Valid characters are a-z, 0-9, hyphen (-).
     * Should match `ipcNamespace` passed in the renderer processes.
     *
     * @default "sentry-ipc"
     */
    ipcNamespace: string;
    /**
     * A function that returns an array of Electron session objects
     *
     * These sessions are used to configure communication between the Electron
     * main and renderer processes.
     *
     * Defaults to () => [session.defaultSession]
     */
    getSessions: () => Session[];
    /**
     * Callback to allow custom naming of renderer processes.
     *
     * If the callback is not set, or it returns `undefined`, the default naming
     * scheme is used.
     */
    getRendererName?: (contents: WebContents) => string | undefined;
    /**
     * Screenshots may contain PII and is an opt-in feature
     *
     * If set to true, screenshots will be captured and included with all JavaScript events.
     * Screenshots are not included for native crashes since it's not possible to capture images of crashed Electron
     * renderers.
     */
    attachScreenshot?: boolean;
    /**
     * Enables injection of 'js-profiling' document policy headers and ensure profiles are forwarded with transactions
     */
    enableRendererProfiling?: boolean;
}
export type ElectronMainOptions = Pick<Partial<ElectronMainOptionsInternal>, 'getSessions' | 'ipcMode' | 'ipcNamespace'> & Omit<ElectronMainOptionsInternal, 'getSessions' | 'ipcMode' | 'ipcNamespace'> & NodeOptions;
/**
 * Initialize Sentry in the Electron main process
 */
export declare function init(userOptions: ElectronMainOptions): void;
//# sourceMappingURL=sdk.d.ts.map