import { Envelope, Event, Profile } from '@sentry/core';
import { ElectronMainOptionsInternal } from './sdk.js';
/**
 * Normalizes all URLs in an event. See {@link normalizeUrl} for more
 * information. Mutates the passed in event.
 *
 * @param event The event to normalize.
 */
export declare function normalizePaths(event: Event, basePath: string): Event;
/** Normalizes URLs in any replay_event items found in an envelope */
export declare function normalizeReplayEnvelope(options: ElectronMainOptionsInternal, envelope: Envelope, basePath: string): Envelope;
/**
 * Normalizes all URLs in a profile
 */
export declare function normaliseProfile(profile: Profile, basePath: string): void;
//# sourceMappingURL=normalize.d.ts.map