import { Client, Integration } from '@sentry/core';
import { WebContents } from 'electron';
import { RendererStatus } from '../../common/ipc.js';
type Options = {
    /**
     * Enables injection of 'include-js-call-stacks-in-crash-reports' document policy headers so that renderer call stacks
     * can be captured from the main process without using the debugger API.
     *
     * Requires Electron >= v34
     *
     * @default false
     */
    captureNativeStacktrace?: boolean;
};
type RendererStatusHandler = (status: RendererStatus, contents: WebContents) => void;
type RendererEventLoopBlockIntegration = Integration & {
    createRendererEventLoopBlockStatusHandler: () => RendererStatusHandler;
};
/**
 * An integration that captures App Not Responding events from renderer processes
 */
export declare const rendererEventLoopBlockIntegration: (options?: Options) => RendererEventLoopBlockIntegration;
/**
 * Creates a hook which notifies the integration when the state of renderers change
 */
export declare function createRendererEventLoopBlockStatusHandler(client: Client): RendererStatusHandler | undefined;
export {};
//# sourceMappingURL=renderer-anr.d.ts.map