interface Options {
    /**
     * How much GPU information to request from Electron `app.getGPUInfo` API.
     * `complete` can take much longer to resolve so the default is `basic`.
     * - 'basic': Usually only the `vendor_id` and `id` but some platforms supply more.
     * - 'complete': More detailed information including full names and driver_version.
     */
    infoLevel: 'basic' | 'complete';
}
/**
 * Adds GPU context to events
 */
export declare const gpuContextIntegration: (options?: Options | undefined) => import("@sentry/core").Integration;
export {};
//# sourceMappingURL=gpu-context.d.ts.map