export type { Breadcrumb, BreadcrumbHint, PolymorphicRequest, SdkInfo, Event, EventHint, ErrorEvent, Exception, Session, SeverityLevel, StackFrame, Stacktrace, Thread, User, Span, } from '@sentry/core';
export { addBreadcrumb, addEventProcessor, addIntegration, amqplibIntegration, anthropicAIIntegration, buildLaunchDarklyFlagUsedHandler, captureCheckIn, captureConsoleIntegration, captureEvent, captureException, captureFeedback, captureMessage, captureSession, close, connectIntegration, consoleIntegration, consoleLoggingIntegration, contextLinesIntegration, continueTrace, createGetModuleFromFilename, createSentryWinstonTransport, createTransport, cron, dataloaderIntegration, dedupeIntegration, endSession, eventFiltersIntegration, expressErrorHandler, expressIntegration, extraErrorDataIntegration, fastifyIntegration, featureFlagsIntegration, firebaseIntegration, flush, fsIntegration, functionToStringIntegration, generateInstrumentOnce, genericPoolIntegration, getActiveSpan, getAutoPerformanceIntegrations, getClient, getCurrentScope, getGlobalScope, getIsolationScope, getRootSpan, getSpanDescendants, getSpanStatusFromHttpCode, getTraceData, getTraceMetaTags, graphqlIntegration, hapiIntegration, httpHeadersToSpanAttributes, httpIntegration, inboundFiltersIntegration, initOpenTelemetry, instrumentSupabaseClient, isEnabled, isInitialized, kafkaIntegration, knexIntegration, koaIntegration, lastEventId, launchDarklyIntegration, linkedErrorsIntegration, localVariablesIntegration, logger, lruMemoizerIntegration, modulesIntegration, mongoIntegration, mongooseIntegration, mysql2Integration, mysqlIntegration, nativeNodeFetchIntegration, NodeClient, nodeContextIntegration, onUnhandledRejectionIntegration, openAIIntegration, OpenFeatureIntegrationHook, openFeatureIntegration, parameterize, postgresIntegration, postgresJsIntegration, prismaIntegration, profiler, redisIntegration, requestDataIntegration, rewriteFramesIntegration, Scope, SEMANTIC_ATTRIBUTE_SENTRY_OP, SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE, SEMANTIC_ATTRIBUTE_SENTRY_SOURCE, SentryContextManager, setContext, setCurrentClient, setExtra, setExtras, setHttpStatus, setMeasurement, setNodeAsyncContextStrategy, setTag, setTags, setupConnectErrorHandler, setupExpressErrorHandler, setupFastifyErrorHandler, setupHapiErrorHandler, setupKoaErrorHandler, setUser, spanToBaggageHeader, spanToJSON, spanToTraceHeader, spotlightIntegration, startInactiveSpan, startNewTrace, startSession, startSpan, startSpanManual, statsigIntegration, supabaseIntegration, suppressTracing, systemErrorIntegration, tediousIntegration, trpcMiddleware, unleashIntegration, updateSpanName, validateOpenTelemetrySetup, winterCGHeadersToDict, withActiveSpan, withIsolationScope, withMonitor, withScope, wrapMcpServerWithSentry, zodErrorsIntegration, } from '@sentry/node';
export type { NodeOptions } from '@sentry/node';
export { electronBreadcrumbsIntegration } from './integrations/electron-breadcrumbs.js';
export { onUncaughtExceptionIntegration } from './integrations/onuncaughtexception.js';
export { sentryMinidumpIntegration } from './integrations/sentry-minidump/index.js';
export { electronMinidumpIntegration } from './integrations/electron-minidump.js';
export { preloadInjectionIntegration } from './integrations/preload-injection.js';
export { mainProcessSessionIntegration } from './integrations/main-process-session.js';
export { browserWindowSessionIntegration } from './integrations/browser-window-session.js';
export { additionalContextIntegration } from './integrations/additional-context.js';
export { electronNetIntegration } from './integrations/net-breadcrumbs.js';
export { childProcessIntegration } from './integrations/child-process.js';
export { screenshotsIntegration } from './integrations/screenshots.js';
export { rendererProfileFromIpc } from './integrations/renderer-profiling.js';
export { normalizePathsIntegration } from './integrations/normalize-paths.js';
export { electronContextIntegration } from './integrations/electron-context.js';
export { gpuContextIntegration } from './integrations/gpu-context.js';
export { rendererEventLoopBlockIntegration } from './integrations/renderer-anr.js';
export { makeElectronTransport } from './transports/electron-net.js';
export { makeElectronOfflineTransport } from './transports/electron-offline-net.js';
export type { ElectronMainOptions } from './sdk.js';
export { init, getDefaultIntegrations } from './sdk.js';
export { defaultStackParser } from './stack-parse.js';
export { IPCMode } from '../common/ipc.js';
//# sourceMappingURL=index.d.ts.map