# Contribute to dartdoc

To _use_ the dartdoc tool, see the [user docs][].
This page contains information relevant for contributors to the dartdoc project.

## Can I help?

Yes!

Start by [using the tool](README.md) and filing issues and requests.

See the [dartdoc API](https://pub.dev/documentation/dartdoc/latest/) docs,
generated by dartdoc.

If you want to contribute, check out the [issue tracker][] and
see if there's an issue that you're passionate about.
If you want to add a new feature that's not yet in the issue tracker,
start by opening an issue. Thanks!

[![Build Status](https://github.com/dart-lang/dartdoc/workflows/Test/badge.svg)](https://github.com/dart-lang/dartdoc/actions?query=workflow%3ATest)

## Making Changes

1. When a change is user-facing, please add a new entry
   to the [changelog][] under the current `-wip` version.
2. Please include a test for your change. `dartdoc` has both
   `package:test`-style unit tests as well as integration tests.
   To run the tests, use `dart run tool/task.dart test`.
3. For major changes, run both `dart run tool/task.dart compare sdk-warnings`
   and `dart run tool/task.dart compare flutter-warnings`, and
   include the summary results in your pull request.
4. Be sure to format your Dart code using `dart format`,
   otherwise our CI will complain.
5. Use `dart run tool/task.dart buildbot` before creating a pull request
   to quickly check for common problems.
   Follow any instructions it outputs, then run again.
6. Post your change via a pull request for review and integration!

## Testing

dartdoc has a number of utility command that can be used to
check for behavior changes or try out your change on arbitrary packages.

```bash
# Serve the latest version of the given package locally on port 9000.
dart run tool/task.dart serve package --name=intl

# Build the SDK docs with the head version and compare its warning
# output and (rough) performance to the main version.
dart run tool/task.dart compare sdk-warnings

# Serve the flutter docs built with the head version on port 8001.
dart run tool/task.dart serve flutter

# Serve the test package (testing/test_package) on port 8002
dart run tool/task.dart serve testing-package
```

There are more commands added all the time,
check out `tool/task.dart` to find each command or
learn how they are implemented.

## License

Please see the [dartdoc license][].

[user docs]: https://github.com/dart-lang/dartdoc#dart-documentation-generator
[issue tracker]: https://github.com/dart-lang/dartdoc/issues
[changelog]: https://github.com/dart-lang/dartdoc/blob/main/CHANGELOG.md
[dartdoc license]: https://github.com/dart-lang/dartdoc/blob/main/LICENSE
