## 2.12.0

* Drop support for ia32 on Dart SDK >=3.8.0.

## 2.11.0

* Add `lazy` and `optional` options to `JSRequire()`.

## 2.10.0

* Add standalone and GitHub tasks for android-riscv64.

## 2.9.0

* Expand `homebrewEditFormula`'s return type from `String` to
  `FutureOr<String>`.

## 2.8.1

* Stop using `dart:cli`.

## 2.8.0

* Add standalone and GitHub tasks for all OS/architecture combinations supported
  by Dart, as well as for Musl Linux.

* Add a `homebrewEditFormula` `ConfigVariable` that allows users to make custom
  modifications to the Homebrew formula after the built-in edits.

## 2.7.2

* Stop attempting to compile native executables for 32-bit Dart SDKs, again. (I
  misunderstood and thought the underlying Dart SDK issue was fixed.)

## 2.7.1

* Make `require` available as a top-level name for JS interop. Dependencies
  should still be defined declaratively through `jsRequires`, but this allows
  Dart code to access attributes like `require.main`.

* Compile native executables for 32-bit Dart SDKs.

## 2.7.0

* The `package:cli_pkg/js.dart` library can now be used by the Dart VM.
  Previously it could only be imported when compiling to JS.

* Add `isBrowser` and `isJS` getters to `package:cli_pkg/js.dart`.

* **Potentially breaking bug fix:** Removed the `process` getter and the
  `PartialProcess` class extension from `package:cli_pkg/js.dart` to avoid
  exporting the `Process` type as part of the API. The package version `2.6.0`
  was rescinded immediately after publishing.

## 2.6.0

* Add `isNodeJs` and `process` getters to `package:cli_pkg/js.dart`.

## 2.5.0

* Add a `wrapJSException()` function in the new `package:cli_pkg/js.dart`
  library to work around [dart-lang/sdk#53105]. This should be called around all
  calls to JS callbacks to avoid unexpected crashes when exceptions are caught
  by Dart code.

  [dart-lang/sdk#53105]: https://github.com/dart-lang/sdk/issues/53105

* Add a `pkg.jsForceStrictMode` configuration option. This defaults to `false`,
  but if it's set to `true`, all generated JS code will be run in strict mode.

## 2.4.7

* Fix a bug where npm packages could crash on Node.js if loaded both through
  `require()` and `import`.

## 2.4.6

* Properly mark NPM packages as `"type": "module"` when `pkg.jsEsmExports` is
  set, and mark all CJS files as explicitly `.cjs`.

## 2.4.5

* Properly set the pub credentials for the latest versions of the Dart SDK.

* `pkg.homebrewFormula` now looks for formula files in the `Formula` directory
  as well as the repository root.

## 2.4.4

* Remove logical OR assignment operators that made the JS code generated by this
  package incompatible with older versions of Node.

## 2.4.3

* Fix a bug where Node.js executables failed with `jsEsmExports` set.

## 2.4.2

* Remove nullish coalescing operators that made the JS code generated by this
  package incompatible with older versions of Node.

## 2.4.1

* Fix a crash on dart sdks under experimental OS support.

* Work around a bug in Vite when bundling packages for the browser.

## 2.4.0

* Add standalone tasks for experimental dart sdks. These tasks are only
  available directly on experimental dart sdks.

## 2.3.0

* Added `pkg.jsEsmExports`. If this is set, `cli_pkg` will generate ESM
  libraries for each target in addition to CommonJS.

* Made `JSRequireTarget` a proper enum.

* Added `JSRequireTarget.defaultTarget`, which is explicitly loaded only by the
  `"default"` [conditional export] in package.json.

  [conditional export]: https://nodejs.org/api/packages.html#packages_conditional_exports

* It's now allowed to set `JSRequire`s with `JSRequireTarget.cli` without
  setting `jsModuleMainLibrary`.

* **Potentially breaking bug fix:** Instead of scraping source maps after the
  fact, added `--no-source-maps` to the default value of `jsReleaseFlags`.

## 2.2.0

* Use the current SDK's `dart` executable to build the standalone snapshot for
  current architecture.

* Generate a native snapshot rather than a self-contained executable on Linux.

## 2.1.9

* Use `readlink -f` in standalone scripts that wrap snapshots on operating
  systems where it's available. This ensures that the path resolution for those
  scripts is accurate even in the presence of complex symlinks.

## 2.1.8

* Properly follow GitHub API pagination links in `pkg-github-fix-permissions` so
  that it fixes all targets, not just the first page of results.

## 2.1.7

* **Important security bug fix:** Fix incorrect file permissions in the
  standalone `.tar.gz` archives. Previously, files in these archives were
  incorrectly marked as world-writable in the archive metadata. While this
  metadata is ignored under most circumstances, users on multi-user systems who
  explicitly pass `--preserve-permissions` or who extract the archives as root
  would end up with an executable that another user on the same system could
  overwrite with malicious code.

* Add a `pkg-github-fix-permissions` task which fixes this security issue in all
  archives which were uploaded to GitHub releases for the current package.

## 2.1.6

* Use `dart run` commands rather than `dart pub run` for compatibility with the
  latest Dart releases.

## 2.1.5

* **Potentially breaking bug fix:** The `pkg-homebrew-update` task must now
  download a repository archive from GitHub in order to generate the sha256
  hash rather than generating it directly from the local repository. This is
  necessary because GitHub changed their `.tar.gz` format so that it no longer
  precisely matches the format generated by `git archive`.

  This is only a breaking change if you were relying on running
  `pkg-homebrew-update` *before* pushing the tag in question to GitHub.

# 2.1.4

* Now merges `"exports"` **objects** declared in the original `package.json`
  when using `JsRequires` with a target other than `all`. Note that string and
  array values will still be overwritten.

# 2.1.3

* Don't mangle lists in automatically-extracted CHANGELOG entries for GitHub
  releases.

# 2.1.2

* Use `dart pub` commands rather than `pub` for compatibility with the latest
  Dart releases.

# 2.1.1

* Narrow the SDK constraint to reflect the use of a new API.

# 2.1.0

* Add `pkg-github-$os-$arch` tasks, which compile and upload binaries for the
  given operating system and architecture.

* `pkg-github-linux`, `pkg-github-macos`, and `pkg-github-windows` now compile
  and upload binaries for all supported architectures.

* Use `dart pub` commands rather than `pub` for compatibility with the latest
  Dart releases.

# 2.0.3

* Fix a bug where dynamic calls to `require()` would always be `null` in an npm
  package.

# 2.0.2

* Fix a bug where an npm package with target-specific `JSRequire`s would include
  an invalid `"main"` field in its `package.json`.

# 2.0.1

* Work around an npm bug that was causing `npm publish` to fail.

# 2.0.0

* **Breaking change:** The `jsRequires` map has been changed to a list of
  `JSRequire` objects. These objects allow packages to specify exactly which
  target(s) a given dependency should be loaded on, so for example they can
  provide a package that loads the `fs` module for Node.js but can still be
  bundled for the browser without it.

# 1.7.0

* Callbacks passed to `ConfigVariable.fn=` can now return nullable values even
  for non-nullable types. Doing so will cause the variable to use its default
  value. The behavior for nullable types remains unchanged.

# 1.6.0

* Add `pkg-standalone-linux-arm64` and `pkg-standalone-mac-arm64` tasks, which
  compile Linux and Mac OS binaries respectively for 64-bit ARM architectures.
  As with other 64-bit architectures, these will compile native executables when
  invoked on the same OS/architecture combination they're targeting, and will
  compile script snapshots otherwise.

* `pkg-standalone-all` now compiles Linux and Mac OS binaries for 64-bit ARM
  architectures.

# 1.5.2

* Use `dart compile exe` and `dart compile aot-snapshot` instead of
  `dart2native` when compiling standalone executables.

* The space character is no longer forbidden in environment constants, since
  https://github.com/dart-lang/sdk/issues/46050 has been fixed.

# 1.5.1

* Properly run executables from source in `testing.dart` when their public names
  are different than their filenames.

# 1.5.0

* Add `pkg.npmAdditionalFiles` to make it possible to add custom files to npm
  packages.

* `pkg.addChocolateyTasks()` no longer automatically adds standalone tasks,
  since Chocolatey tasks no longer depend on standalone tasks.

* `pkg-chocolatey` now creates a file named `LICENSE.txt` rather than `LICENSE`,
  at the request of the Chocolatey reviewers.

# 1.4.0

* Add `pkg.environmentConstants` to make it possible to define custom
  environment constants for the compiled executables.

# 1.3.0

* Migrate to null-safety.

# 1.2.0

* Add a `pkg.githubBearerToken` to make it easier to integrate with GitHub
  actions.

* Generate a fully standalone executable on Linux rather than a native snapshot.

# 1.1.0

* The main function generated by this package will return a `Promise` if the
  corresponding Dart main function returns a `Future`.

# 1.0.0

* Initial stable release.

### Changes since 1.0.0-beta.13

* Don't fold link reference declarations like paragraphs when generating GitHub
  release notes.

# 1.0.0-beta.13

* Add a `ConfigVariable.defaultValue` property to get the default value for
  variables that are overridden by functions.

* Fix a typo in error messages when files need to be regenerated for tests.

# 1.0.0-beta.12

* Deploy Chocolatey packages as source files rather than a zip file, to avoid
  validation errors around the need for a `VERIFICATION` file.

# 1.0.0-beta.11

* Properly load the Dart SDK license when it's in the directory above the SDK,
  as in a Homebrew installation.

* Use the latest version of the `xml` package.

# 1.0.0-beta.10

* **Breaking change:** All configurable variables are now defined as
  `ConfigVariable` objects rather than top-level fields. These objects make it
  possible to configure variables with callback functions and to freeze those
  variables once execution has begun.

* Properly handle git repositories that use branch names other than `master`.

# 1.0.0-beta.9

* Improve error messages if release notes can't be extracted from
  `CHANGELOG.md`.

# 1.0.0-beta.8

* Fixes a bug when reading a `CHANGELOG.md` with Windows-style line endings.

# 1.0.0-beta.7

* **Breaking change:** Dart snapshots are now named based on the executable name
  (specified in the pubspec or in `pkg.executables`) instead of the name of the
  Dart file in `bin`.

# 1.0.0-beta.6

* **Breaking change:** Chocolatey now uses the `choco` CLI to build and deploy
  packages, rather than re-implementing its logic in Dart. In particular:

  * The `pkg-chocolatey-build` task has been renamed to `pkg-chocolatey-pack` to
    match the CLI's naming scheme.

  * The `pkg-chocolatey-pack` and `pkg-chocolatey-deploy` tasks must be run in
    an environment with the `choco` command available.

* Add a `pkg-chocolatey` command that builds an un-archived Chocolatey package
  directory.

* Rather than releasing binary snapshots on Chocolatey, compile the source code
  to compile native executables on users' machines.

* Add a `chocolateyFiles` getter that returns the files that should be included
  in the Chocolatey package.

* Depend on the correct version of pre-release Dart SDKs from Chocolatey
  packages.

# 1.0.0-beta.5

* Use the correct URL when fetching GitHub release metadata.

# 1.0.0-beta.4

* Add a `pkg.npmDistTag` getter that controls the distribution tag for an npm
  release.

* Add a `pkg.homebrewCreateVersionedFormula` getter that controls whether the
  Homebrew release creates a new formula or updates an existing one.

* Run `pub publish --force` so it doesn't hang forever.

* Properly parse GitHub repositories from HTTP URLs ending in `.git`.

* Drop support for Mac OS ia32 packages, since Dart 2.7 doesn't support them
  anymore.

# 1.0.0-beta.3

* Add a `cli_pkg/testing.dart` library to make it easier for users to
  efficiently and reliably test their executables.

# 1.0.0-beta.2

* Add a `pkg-standalone-dev` task for building a script that can be invoked for
  testing.

* Fix a bug where the version variable wouldn't be set for certain executables.

# 1.0.0-beta.1

* Initial beta release.
