// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/collection_service.proto

//go:build protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListCollectionsRequest_Order int32

const (
	ListCollectionsRequest_ORDER_UNSPECIFIED ListCollectionsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListCollectionsRequest_ORDER_CREATE_TIME_DESC ListCollectionsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListCollectionsRequest_ORDER_CREATE_TIME_ASC ListCollectionsRequest_Order = 2
)

// Enum value maps for ListCollectionsRequest_Order.
var (
	ListCollectionsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListCollectionsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListCollectionsRequest_Order) Enum() *ListCollectionsRequest_Order {
	p := new(ListCollectionsRequest_Order)
	*p = x
	return p
}

func (x ListCollectionsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListCollectionsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_plugin_v1beta1_collection_service_proto_enumTypes[0].Descriptor()
}

func (ListCollectionsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_plugin_v1beta1_collection_service_proto_enumTypes[0]
}

func (x ListCollectionsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetCollectionsRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CollectionRefs *[]*CollectionRef      `protobuf:"bytes,1,rep,name=collection_refs,json=collectionRefs,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *GetCollectionsRequest) Reset() {
	*x = GetCollectionsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCollectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCollectionsRequest) ProtoMessage() {}

func (x *GetCollectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCollectionsRequest) GetCollectionRefs() []*CollectionRef {
	if x != nil {
		if x.xxx_hidden_CollectionRefs != nil {
			return *x.xxx_hidden_CollectionRefs
		}
	}
	return nil
}

func (x *GetCollectionsRequest) SetCollectionRefs(v []*CollectionRef) {
	x.xxx_hidden_CollectionRefs = &v
}

type GetCollectionsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Collections to request.
	CollectionRefs []*CollectionRef
}

func (b0 GetCollectionsRequest_builder) Build() *GetCollectionsRequest {
	m0 := &GetCollectionsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CollectionRefs = &b.CollectionRefs
	return m0
}

type GetCollectionsResponse struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Collections *[]*Collection         `protobuf:"bytes,1,rep,name=collections,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GetCollectionsResponse) Reset() {
	*x = GetCollectionsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCollectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCollectionsResponse) ProtoMessage() {}

func (x *GetCollectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCollectionsResponse) GetCollections() []*Collection {
	if x != nil {
		if x.xxx_hidden_Collections != nil {
			return *x.xxx_hidden_Collections
		}
	}
	return nil
}

func (x *GetCollectionsResponse) SetCollections(v []*Collection) {
	x.xxx_hidden_Collections = &v
}

type GetCollectionsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Collections in the same order as requested.
	Collections []*Collection
}

func (b0 GetCollectionsResponse_builder) Build() *GetCollectionsResponse {
	m0 := &GetCollectionsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Collections = &b.Collections
	return m0
}

type ListCollectionsRequest struct {
	state                protoimpl.MessageState       `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                       `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                       `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Order     ListCollectionsRequest_Order `protobuf:"varint,3,opt,name=order,proto3,enum=buf.registry.plugin.v1beta1.ListCollectionsRequest_Order"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListCollectionsRequest) Reset() {
	*x = ListCollectionsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCollectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCollectionsRequest) ProtoMessage() {}

func (x *ListCollectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCollectionsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListCollectionsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListCollectionsRequest) GetOrder() ListCollectionsRequest_Order {
	if x != nil {
		return x.xxx_hidden_Order
	}
	return ListCollectionsRequest_ORDER_UNSPECIFIED
}

func (x *ListCollectionsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListCollectionsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListCollectionsRequest) SetOrder(v ListCollectionsRequest_Order) {
	x.xxx_hidden_Order = v
}

type ListCollectionsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The order to return the Plugins.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListCollectionsRequest_Order
}

func (b0 ListCollectionsRequest_builder) Build() *ListCollectionsRequest {
	m0 := &ListCollectionsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Order = b.Order
	return m0
}

type ListCollectionsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3"`
	xxx_hidden_Collections   *[]*Collection         `protobuf:"bytes,2,rep,name=collections,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListCollectionsResponse) Reset() {
	*x = ListCollectionsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCollectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCollectionsResponse) ProtoMessage() {}

func (x *ListCollectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCollectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListCollectionsResponse) GetCollections() []*Collection {
	if x != nil {
		if x.xxx_hidden_Collections != nil {
			return *x.xxx_hidden_Collections
		}
	}
	return nil
}

func (x *ListCollectionsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

func (x *ListCollectionsResponse) SetCollections(v []*Collection) {
	x.xxx_hidden_Collections = &v
}

type ListCollectionsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Collections.
	Collections []*Collection
}

func (b0 ListCollectionsResponse_builder) Build() *ListCollectionsResponse {
	m0 := &ListCollectionsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_NextPageToken = b.NextPageToken
	x.xxx_hidden_Collections = &b.Collections
	return m0
}

type GetPluginCollectionAssociationsRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PluginRefs *[]*PluginRef          `protobuf:"bytes,1,rep,name=plugin_refs,json=pluginRefs,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *GetPluginCollectionAssociationsRequest) Reset() {
	*x = GetPluginCollectionAssociationsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPluginCollectionAssociationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPluginCollectionAssociationsRequest) ProtoMessage() {}

func (x *GetPluginCollectionAssociationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPluginCollectionAssociationsRequest) GetPluginRefs() []*PluginRef {
	if x != nil {
		if x.xxx_hidden_PluginRefs != nil {
			return *x.xxx_hidden_PluginRefs
		}
	}
	return nil
}

func (x *GetPluginCollectionAssociationsRequest) SetPluginRefs(v []*PluginRef) {
	x.xxx_hidden_PluginRefs = &v
}

type GetPluginCollectionAssociationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugins to request Collections for.
	PluginRefs []*PluginRef
}

func (b0 GetPluginCollectionAssociationsRequest_builder) Build() *GetPluginCollectionAssociationsRequest {
	m0 := &GetPluginCollectionAssociationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginRefs = &b.PluginRefs
	return m0
}

type GetPluginCollectionAssociationsResponse struct {
	state                   protoimpl.MessageState                                  `protogen:"opaque.v1"`
	xxx_hidden_Associations *[]*GetPluginCollectionAssociationsResponse_Association `protobuf:"bytes,1,rep,name=associations,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetPluginCollectionAssociationsResponse) Reset() {
	*x = GetPluginCollectionAssociationsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPluginCollectionAssociationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPluginCollectionAssociationsResponse) ProtoMessage() {}

func (x *GetPluginCollectionAssociationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPluginCollectionAssociationsResponse) GetAssociations() []*GetPluginCollectionAssociationsResponse_Association {
	if x != nil {
		if x.xxx_hidden_Associations != nil {
			return *x.xxx_hidden_Associations
		}
	}
	return nil
}

func (x *GetPluginCollectionAssociationsResponse) SetAssociations(v []*GetPluginCollectionAssociationsResponse_Association) {
	x.xxx_hidden_Associations = &v
}

type GetPluginCollectionAssociationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Associations for the requested Plugins in the same order as requested.
	Associations []*GetPluginCollectionAssociationsResponse_Association
}

func (b0 GetPluginCollectionAssociationsResponse_builder) Build() *GetPluginCollectionAssociationsResponse {
	m0 := &GetPluginCollectionAssociationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Associations = &b.Associations
	return m0
}

// The Associations for the requested Plugins.
type GetPluginCollectionAssociationsResponse_Association struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PluginId      string                 `protobuf:"bytes,1,opt,name=plugin_id,json=pluginId,proto3"`
	xxx_hidden_CollectionIds []string               `protobuf:"bytes,2,rep,name=collection_ids,json=collectionIds,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GetPluginCollectionAssociationsResponse_Association) Reset() {
	*x = GetPluginCollectionAssociationsResponse_Association{}
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPluginCollectionAssociationsResponse_Association) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPluginCollectionAssociationsResponse_Association) ProtoMessage() {}

func (x *GetPluginCollectionAssociationsResponse_Association) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetPluginCollectionAssociationsResponse_Association) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *GetPluginCollectionAssociationsResponse_Association) GetCollectionIds() []string {
	if x != nil {
		return x.xxx_hidden_CollectionIds
	}
	return nil
}

func (x *GetPluginCollectionAssociationsResponse_Association) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

func (x *GetPluginCollectionAssociationsResponse_Association) SetCollectionIds(v []string) {
	x.xxx_hidden_CollectionIds = v
}

type GetPluginCollectionAssociationsResponse_Association_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id of the Plugin.
	PluginId string
	// The collection ids associated with the Plugin.
	CollectionIds []string
}

func (b0 GetPluginCollectionAssociationsResponse_Association_builder) Build() *GetPluginCollectionAssociationsResponse_Association {
	m0 := &GetPluginCollectionAssociationsResponse_Association{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginId = b.PluginId
	x.xxx_hidden_CollectionIds = b.CollectionIds
	return m0
}

var File_buf_registry_plugin_v1beta1_collection_service_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_collection_service_proto_rawDesc = "" +
	"\n" +
	"4buf/registry/plugin/v1beta1/collection_service.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a,buf/registry/plugin/v1beta1/collection.proto\x1a(buf/registry/plugin/v1beta1/plugin.proto\x1a\x1bbuf/validate/validate.proto\"y\n" +
	"\x15GetCollectionsRequest\x12`\n" +
	"\x0fcollection_refs\x18\x01 \x03(\v2*.buf.registry.plugin.v1beta1.CollectionRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x0ecollectionRefs\"m\n" +
	"\x16GetCollectionsResponse\x12S\n" +
	"\vcollections\x18\x01 \x03(\v2'.buf.registry.plugin.v1beta1.CollectionB\b\xbaH\x05\x92\x01\x02\b\x01R\vcollections\"\x9a\x02\n" +
	"\x16ListCollectionsRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12Y\n" +
	"\x05order\x18\x03 \x01(\x0e29.buf.registry.plugin.v1beta1.ListCollectionsRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\"\x96\x01\n" +
	"\x17ListCollectionsResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12I\n" +
	"\vcollections\x18\x02 \x03(\v2'.buf.registry.plugin.v1beta1.CollectionR\vcollections\"~\n" +
	"&GetPluginCollectionAssociationsRequest\x12T\n" +
	"\vplugin_refs\x18\x01 \x03(\v2&.buf.registry.plugin.v1beta1.PluginRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\n" +
	"pluginRefs\"\xf2\x01\n" +
	"'GetPluginCollectionAssociationsResponse\x12t\n" +
	"\fassociations\x18\x01 \x03(\v2P.buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse.AssociationR\fassociations\x1aQ\n" +
	"\vAssociation\x12\x1b\n" +
	"\tplugin_id\x18\x01 \x01(\tR\bpluginId\x12%\n" +
	"\x0ecollection_ids\x18\x02 \x03(\tR\rcollectionIds2\xcb\x03\n" +
	"\x11CollectionService\x12~\n" +
	"\x0eGetCollections\x122.buf.registry.plugin.v1beta1.GetCollectionsRequest\x1a3.buf.registry.plugin.v1beta1.GetCollectionsResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x0fListCollections\x123.buf.registry.plugin.v1beta1.ListCollectionsRequest\x1a4.buf.registry.plugin.v1beta1.ListCollectionsResponse\"\x03\x90\x02\x01\x12\xb1\x01\n" +
	"\x1fGetPluginCollectionAssociations\x12C.buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsRequest\x1aD.buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse\"\x03\x90\x02\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_collection_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_buf_registry_plugin_v1beta1_collection_service_proto_goTypes = []any{
	(ListCollectionsRequest_Order)(0),                           // 0: buf.registry.plugin.v1beta1.ListCollectionsRequest.Order
	(*GetCollectionsRequest)(nil),                               // 1: buf.registry.plugin.v1beta1.GetCollectionsRequest
	(*GetCollectionsResponse)(nil),                              // 2: buf.registry.plugin.v1beta1.GetCollectionsResponse
	(*ListCollectionsRequest)(nil),                              // 3: buf.registry.plugin.v1beta1.ListCollectionsRequest
	(*ListCollectionsResponse)(nil),                             // 4: buf.registry.plugin.v1beta1.ListCollectionsResponse
	(*GetPluginCollectionAssociationsRequest)(nil),              // 5: buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsRequest
	(*GetPluginCollectionAssociationsResponse)(nil),             // 6: buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse
	(*GetPluginCollectionAssociationsResponse_Association)(nil), // 7: buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse.Association
	(*CollectionRef)(nil),                                       // 8: buf.registry.plugin.v1beta1.CollectionRef
	(*Collection)(nil),                                          // 9: buf.registry.plugin.v1beta1.Collection
	(*PluginRef)(nil),                                           // 10: buf.registry.plugin.v1beta1.PluginRef
}
var file_buf_registry_plugin_v1beta1_collection_service_proto_depIdxs = []int32{
	8,  // 0: buf.registry.plugin.v1beta1.GetCollectionsRequest.collection_refs:type_name -> buf.registry.plugin.v1beta1.CollectionRef
	9,  // 1: buf.registry.plugin.v1beta1.GetCollectionsResponse.collections:type_name -> buf.registry.plugin.v1beta1.Collection
	0,  // 2: buf.registry.plugin.v1beta1.ListCollectionsRequest.order:type_name -> buf.registry.plugin.v1beta1.ListCollectionsRequest.Order
	9,  // 3: buf.registry.plugin.v1beta1.ListCollectionsResponse.collections:type_name -> buf.registry.plugin.v1beta1.Collection
	10, // 4: buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsRequest.plugin_refs:type_name -> buf.registry.plugin.v1beta1.PluginRef
	7,  // 5: buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse.associations:type_name -> buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse.Association
	1,  // 6: buf.registry.plugin.v1beta1.CollectionService.GetCollections:input_type -> buf.registry.plugin.v1beta1.GetCollectionsRequest
	3,  // 7: buf.registry.plugin.v1beta1.CollectionService.ListCollections:input_type -> buf.registry.plugin.v1beta1.ListCollectionsRequest
	5,  // 8: buf.registry.plugin.v1beta1.CollectionService.GetPluginCollectionAssociations:input_type -> buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsRequest
	2,  // 9: buf.registry.plugin.v1beta1.CollectionService.GetCollections:output_type -> buf.registry.plugin.v1beta1.GetCollectionsResponse
	4,  // 10: buf.registry.plugin.v1beta1.CollectionService.ListCollections:output_type -> buf.registry.plugin.v1beta1.ListCollectionsResponse
	6,  // 11: buf.registry.plugin.v1beta1.CollectionService.GetPluginCollectionAssociations:output_type -> buf.registry.plugin.v1beta1.GetPluginCollectionAssociationsResponse
	9,  // [9:12] is the sub-list for method output_type
	6,  // [6:9] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_collection_service_proto_init() }
func file_buf_registry_plugin_v1beta1_collection_service_proto_init() {
	if File_buf_registry_plugin_v1beta1_collection_service_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_collection_proto_init()
	file_buf_registry_plugin_v1beta1_plugin_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_collection_service_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_collection_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_collection_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_collection_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_plugin_v1beta1_collection_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_plugin_v1beta1_collection_service_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_collection_service_proto = out.File
	file_buf_registry_plugin_v1beta1_collection_service_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_collection_service_proto_depIdxs = nil
}
