// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/module/v1/resource.proto

//go:build protoopaque

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A Module, Label, or Commit.
type Resource struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value isResource_Value       `protobuf_oneof:"value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Resource) GetModule() *Module {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*resource_Module); ok {
			return x.Module
		}
	}
	return nil
}

func (x *Resource) GetLabel() *Label {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*resource_Label); ok {
			return x.Label
		}
	}
	return nil
}

func (x *Resource) GetCommit() *Commit {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*resource_Commit); ok {
			return x.Commit
		}
	}
	return nil
}

func (x *Resource) SetModule(v *Module) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &resource_Module{v}
}

func (x *Resource) SetLabel(v *Label) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &resource_Label{v}
}

func (x *Resource) SetCommit(v *Commit) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &resource_Commit{v}
}

func (x *Resource) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *Resource) HasModule() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*resource_Module)
	return ok
}

func (x *Resource) HasLabel() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*resource_Label)
	return ok
}

func (x *Resource) HasCommit() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*resource_Commit)
	return ok
}

func (x *Resource) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *Resource) ClearModule() {
	if _, ok := x.xxx_hidden_Value.(*resource_Module); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *Resource) ClearLabel() {
	if _, ok := x.xxx_hidden_Value.(*resource_Label); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *Resource) ClearCommit() {
	if _, ok := x.xxx_hidden_Value.(*resource_Commit); ok {
		x.xxx_hidden_Value = nil
	}
}

const Resource_Value_not_set_case case_Resource_Value = 0
const Resource_Module_case case_Resource_Value = 1
const Resource_Label_case case_Resource_Value = 2
const Resource_Commit_case case_Resource_Value = 3

func (x *Resource) WhichValue() case_Resource_Value {
	if x == nil {
		return Resource_Value_not_set_case
	}
	switch x.xxx_hidden_Value.(type) {
	case *resource_Module:
		return Resource_Module_case
	case *resource_Label:
		return Resource_Label_case
	case *resource_Commit:
		return Resource_Commit_case
	default:
		return Resource_Value_not_set_case
	}
}

type Resource_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Value:
	Module *Module
	Label  *Label
	Commit *Commit
	// -- end of xxx_hidden_Value
}

func (b0 Resource_builder) Build() *Resource {
	m0 := &Resource{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Module != nil {
		x.xxx_hidden_Value = &resource_Module{b.Module}
	}
	if b.Label != nil {
		x.xxx_hidden_Value = &resource_Label{b.Label}
	}
	if b.Commit != nil {
		x.xxx_hidden_Value = &resource_Commit{b.Commit}
	}
	return m0
}

type case_Resource_Value protoreflect.FieldNumber

func (x case_Resource_Value) String() string {
	md := file_buf_registry_module_v1_resource_proto_msgTypes[0].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isResource_Value interface {
	isResource_Value()
}

type resource_Module struct {
	Module *Module `protobuf:"bytes,1,opt,name=module,proto3,oneof"`
}

type resource_Label struct {
	Label *Label `protobuf:"bytes,2,opt,name=label,proto3,oneof"`
}

type resource_Commit struct {
	Commit *Commit `protobuf:"bytes,3,opt,name=commit,proto3,oneof"`
}

func (*resource_Module) isResource_Value() {}

func (*resource_Label) isResource_Value() {}

func (*resource_Commit) isResource_Value() {}

// A reference to any of:
//   - Module
//   - Label
//   - Commit
//
// The id or name is resolved to a specific resource.
// If an id is passed, this is interpreted as being the id of the resource.
// If a name is passed, the semantics according to ResourceRef.Name are applied.
//
// ResourceRefs can only be used in requests, and only for read-only RPCs, that is
// you should not use an arbitrary reference when modifying a specific resource.
type ResourceRef struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value isResourceRef_Value    `protobuf_oneof:"value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ResourceRef) Reset() {
	*x = ResourceRef{}
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRef) ProtoMessage() {}

func (x *ResourceRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ResourceRef) GetId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*resourceRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *ResourceRef) GetName() *ResourceRef_Name {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*resourceRef_Name_); ok {
			return x.Name
		}
	}
	return nil
}

func (x *ResourceRef) SetId(v string) {
	x.xxx_hidden_Value = &resourceRef_Id{v}
}

func (x *ResourceRef) SetName(v *ResourceRef_Name) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &resourceRef_Name_{v}
}

func (x *ResourceRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *ResourceRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*resourceRef_Id)
	return ok
}

func (x *ResourceRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*resourceRef_Name_)
	return ok
}

func (x *ResourceRef) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *ResourceRef) ClearId() {
	if _, ok := x.xxx_hidden_Value.(*resourceRef_Id); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *ResourceRef) ClearName() {
	if _, ok := x.xxx_hidden_Value.(*resourceRef_Name_); ok {
		x.xxx_hidden_Value = nil
	}
}

const ResourceRef_Value_not_set_case case_ResourceRef_Value = 0
const ResourceRef_Id_case case_ResourceRef_Value = 1
const ResourceRef_Name_case case_ResourceRef_Value = 2

func (x *ResourceRef) WhichValue() case_ResourceRef_Value {
	if x == nil {
		return ResourceRef_Value_not_set_case
	}
	switch x.xxx_hidden_Value.(type) {
	case *resourceRef_Id:
		return ResourceRef_Id_case
	case *resourceRef_Name_:
		return ResourceRef_Name_case
	default:
		return ResourceRef_Value_not_set_case
	}
}

type ResourceRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Value:
	// The id of the resource.
	Id *string
	// The fully-qualified name of the resource.
	Name *ResourceRef_Name
	// -- end of xxx_hidden_Value
}

func (b0 ResourceRef_builder) Build() *ResourceRef {
	m0 := &ResourceRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.xxx_hidden_Value = &resourceRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.xxx_hidden_Value = &resourceRef_Name_{b.Name}
	}
	return m0
}

type case_ResourceRef_Value protoreflect.FieldNumber

func (x case_ResourceRef_Value) String() string {
	md := file_buf_registry_module_v1_resource_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isResourceRef_Value interface {
	isResourceRef_Value()
}

type resourceRef_Id struct {
	// The id of the resource.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type resourceRef_Name_ struct {
	// The fully-qualified name of the resource.
	Name *ResourceRef_Name `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*resourceRef_Id) isResourceRef_Value() {}

func (*resourceRef_Name_) isResourceRef_Value() {}

// The fully-qualified name component of a ResourceRef.
//
// The following semantics are applied:
//   - If the child oneof is not specified, the name is interpreted to reference a Module.
//   - If label_name is specified, the name is interpreted to reference a Label.
//   - If ref is specified, it is interpreted to be either an id or name.
//   - If an id, this is equivalent to setting the id field on ResourceRef. However,
//     backends can choose to validate that the owner and module fields match the resource
//     referenced, as additional validation.
//   - If a name, this is interpreted to be a Label name.
//   - If there is a conflict between names across resources (for example, there is a Commit id
//     and Label name of the same value), the following order of precedence is applied:
//   - Commit
//   - Label
//
// Names can only be used in requests, and only for read-only RPCs, that is
// you should not use an arbitrary reference when modifying a specific resource.
type ResourceRef_Name struct {
	state             protoimpl.MessageState   `protogen:"opaque.v1"`
	xxx_hidden_Owner  string                   `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Module string                   `protobuf:"bytes,2,opt,name=module,proto3"`
	xxx_hidden_Child  isResourceRef_Name_Child `protobuf_oneof:"child"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ResourceRef_Name) Reset() {
	*x = ResourceRef_Name{}
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceRef_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRef_Name) ProtoMessage() {}

func (x *ResourceRef_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_resource_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ResourceRef_Name) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *ResourceRef_Name) GetModule() string {
	if x != nil {
		return x.xxx_hidden_Module
	}
	return ""
}

func (x *ResourceRef_Name) GetLabelName() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Child.(*resourceRef_Name_LabelName); ok {
			return x.LabelName
		}
	}
	return ""
}

func (x *ResourceRef_Name) GetRef() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Child.(*resourceRef_Name_Ref); ok {
			return x.Ref
		}
	}
	return ""
}

func (x *ResourceRef_Name) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *ResourceRef_Name) SetModule(v string) {
	x.xxx_hidden_Module = v
}

func (x *ResourceRef_Name) SetLabelName(v string) {
	x.xxx_hidden_Child = &resourceRef_Name_LabelName{v}
}

func (x *ResourceRef_Name) SetRef(v string) {
	x.xxx_hidden_Child = &resourceRef_Name_Ref{v}
}

func (x *ResourceRef_Name) HasChild() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Child != nil
}

func (x *ResourceRef_Name) HasLabelName() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Child.(*resourceRef_Name_LabelName)
	return ok
}

func (x *ResourceRef_Name) HasRef() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Child.(*resourceRef_Name_Ref)
	return ok
}

func (x *ResourceRef_Name) ClearChild() {
	x.xxx_hidden_Child = nil
}

func (x *ResourceRef_Name) ClearLabelName() {
	if _, ok := x.xxx_hidden_Child.(*resourceRef_Name_LabelName); ok {
		x.xxx_hidden_Child = nil
	}
}

func (x *ResourceRef_Name) ClearRef() {
	if _, ok := x.xxx_hidden_Child.(*resourceRef_Name_Ref); ok {
		x.xxx_hidden_Child = nil
	}
}

const ResourceRef_Name_Child_not_set_case case_ResourceRef_Name_Child = 0
const ResourceRef_Name_LabelName_case case_ResourceRef_Name_Child = 3
const ResourceRef_Name_Ref_case case_ResourceRef_Name_Child = 4

func (x *ResourceRef_Name) WhichChild() case_ResourceRef_Name_Child {
	if x == nil {
		return ResourceRef_Name_Child_not_set_case
	}
	switch x.xxx_hidden_Child.(type) {
	case *resourceRef_Name_LabelName:
		return ResourceRef_Name_LabelName_case
	case *resourceRef_Name_Ref:
		return ResourceRef_Name_Ref_case
	default:
		return ResourceRef_Name_Child_not_set_case
	}
}

type ResourceRef_Name_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the User or Organization that owns the resource.
	Owner string
	// The name of the Module that contains or is the resource.
	Module string
	// If the oneof is present but empty, this should be treated as not present.

	// Fields of oneof xxx_hidden_Child:
	// The name of the Label.
	//
	// If this value is present but empty, this should be treated as not present, that is
	// an empty value is the same as a null value.
	LabelName *string
	// The untyped reference, applying the semantics as documented on the Name message.
	//
	// If this value is present but empty, this should be treated as not present, that is
	// an empty value is the same as a null value.
	Ref *string
	// -- end of xxx_hidden_Child
}

func (b0 ResourceRef_Name_builder) Build() *ResourceRef_Name {
	m0 := &ResourceRef_Name{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Module = b.Module
	if b.LabelName != nil {
		x.xxx_hidden_Child = &resourceRef_Name_LabelName{*b.LabelName}
	}
	if b.Ref != nil {
		x.xxx_hidden_Child = &resourceRef_Name_Ref{*b.Ref}
	}
	return m0
}

type case_ResourceRef_Name_Child protoreflect.FieldNumber

func (x case_ResourceRef_Name_Child) String() string {
	md := file_buf_registry_module_v1_resource_proto_msgTypes[2].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isResourceRef_Name_Child interface {
	isResourceRef_Name_Child()
}

type resourceRef_Name_LabelName struct {
	// The name of the Label.
	//
	// If this value is present but empty, this should be treated as not present, that is
	// an empty value is the same as a null value.
	LabelName string `protobuf:"bytes,3,opt,name=label_name,json=labelName,proto3,oneof"`
}

type resourceRef_Name_Ref struct {
	// The untyped reference, applying the semantics as documented on the Name message.
	//
	// If this value is present but empty, this should be treated as not present, that is
	// an empty value is the same as a null value.
	Ref string `protobuf:"bytes,4,opt,name=ref,proto3,oneof"`
}

func (*resourceRef_Name_LabelName) isResourceRef_Name_Child() {}

func (*resourceRef_Name_Ref) isResourceRef_Name_Child() {}

var File_buf_registry_module_v1_resource_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1_resource_proto_rawDesc = "" +
	"\n" +
	"%buf/registry/module/v1/resource.proto\x12\x16buf.registry.module.v1\x1a#buf/registry/module/v1/commit.proto\x1a\"buf/registry/module/v1/label.proto\x1a#buf/registry/module/v1/module.proto\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\"\xc5\x01\n" +
	"\bResource\x128\n" +
	"\x06module\x18\x01 \x01(\v2\x1e.buf.registry.module.v1.ModuleH\x00R\x06module\x125\n" +
	"\x05label\x18\x02 \x01(\v2\x1d.buf.registry.module.v1.LabelH\x00R\x05label\x128\n" +
	"\x06commit\x18\x03 \x01(\v2\x1e.buf.registry.module.v1.CommitH\x00R\x06commitB\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01\"\x99\x02\n" +
	"\vResourceRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12>\n" +
	"\x04name\x18\x02 \x01(\v2(.buf.registry.module.v1.ResourceRef.NameH\x00R\x04name\x1a\x93\x01\n" +
	"\x04Name\x12 \n" +
	"\x05owner\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x18 R\x05owner\x12!\n" +
	"\x06module\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x06module\x12)\n" +
	"\n" +
	"label_name\x18\x03 \x01(\tB\b\xbaH\x05r\x03\x18\xfa\x01H\x00R\tlabelName\x12\x12\n" +
	"\x03ref\x18\x04 \x01(\tH\x00R\x03refB\a\n" +
	"\x05child:\b\xea\xc5+\x04\b\x01\x18\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01BWZUbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1;modulev1b\x06proto3"

var file_buf_registry_module_v1_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_module_v1_resource_proto_goTypes = []any{
	(*Resource)(nil),         // 0: buf.registry.module.v1.Resource
	(*ResourceRef)(nil),      // 1: buf.registry.module.v1.ResourceRef
	(*ResourceRef_Name)(nil), // 2: buf.registry.module.v1.ResourceRef.Name
	(*Module)(nil),           // 3: buf.registry.module.v1.Module
	(*Label)(nil),            // 4: buf.registry.module.v1.Label
	(*Commit)(nil),           // 5: buf.registry.module.v1.Commit
}
var file_buf_registry_module_v1_resource_proto_depIdxs = []int32{
	3, // 0: buf.registry.module.v1.Resource.module:type_name -> buf.registry.module.v1.Module
	4, // 1: buf.registry.module.v1.Resource.label:type_name -> buf.registry.module.v1.Label
	5, // 2: buf.registry.module.v1.Resource.commit:type_name -> buf.registry.module.v1.Commit
	2, // 3: buf.registry.module.v1.ResourceRef.name:type_name -> buf.registry.module.v1.ResourceRef.Name
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_resource_proto_init() }
func file_buf_registry_module_v1_resource_proto_init() {
	if File_buf_registry_module_v1_resource_proto != nil {
		return
	}
	file_buf_registry_module_v1_commit_proto_init()
	file_buf_registry_module_v1_label_proto_init()
	file_buf_registry_module_v1_module_proto_init()
	file_buf_registry_module_v1_resource_proto_msgTypes[0].OneofWrappers = []any{
		(*resource_Module)(nil),
		(*resource_Label)(nil),
		(*resource_Commit)(nil),
	}
	file_buf_registry_module_v1_resource_proto_msgTypes[1].OneofWrappers = []any{
		(*resourceRef_Id)(nil),
		(*resourceRef_Name_)(nil),
	}
	file_buf_registry_module_v1_resource_proto_msgTypes[2].OneofWrappers = []any{
		(*resourceRef_Name_LabelName)(nil),
		(*resourceRef_Name_Ref)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1_resource_proto_rawDesc), len(file_buf_registry_module_v1_resource_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_module_v1_resource_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_resource_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1_resource_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_resource_proto = out.File
	file_buf_registry_module_v1_resource_proto_goTypes = nil
	file_buf_registry_module_v1_resource_proto_depIdxs = nil
}
