// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/module/v1/commit.proto

//go:build protoopaque

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A commit on a specific Module.
//
// Commits are immutable.
//
// Many Commits may be associated with one Digest.
//
// Note that the Digest returned on a Commit depends on the requested DigestType in the
// RPC that returned the Commit.
type Commit struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id               string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime       *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_OwnerId          string                 `protobuf:"bytes,3,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_ModuleId         string                 `protobuf:"bytes,4,opt,name=module_id,json=moduleId,proto3"`
	xxx_hidden_Digest           *Digest                `protobuf:"bytes,5,opt,name=digest,proto3"`
	xxx_hidden_CreatedByUserId  string                 `protobuf:"bytes,6,opt,name=created_by_user_id,json=createdByUserId,proto3"`
	xxx_hidden_SourceControlUrl string                 `protobuf:"bytes,7,opt,name=source_control_url,json=sourceControlUrl,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *Commit) Reset() {
	*x = Commit{}
	mi := &file_buf_registry_module_v1_commit_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Commit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Commit) ProtoMessage() {}

func (x *Commit) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_commit_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Commit) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Commit) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Commit) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *Commit) GetModuleId() string {
	if x != nil {
		return x.xxx_hidden_ModuleId
	}
	return ""
}

func (x *Commit) GetDigest() *Digest {
	if x != nil {
		return x.xxx_hidden_Digest
	}
	return nil
}

func (x *Commit) GetCreatedByUserId() string {
	if x != nil {
		return x.xxx_hidden_CreatedByUserId
	}
	return ""
}

func (x *Commit) GetSourceControlUrl() string {
	if x != nil {
		return x.xxx_hidden_SourceControlUrl
	}
	return ""
}

func (x *Commit) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Commit) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Commit) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *Commit) SetModuleId(v string) {
	x.xxx_hidden_ModuleId = v
}

func (x *Commit) SetDigest(v *Digest) {
	x.xxx_hidden_Digest = v
}

func (x *Commit) SetCreatedByUserId(v string) {
	x.xxx_hidden_CreatedByUserId = v
}

func (x *Commit) SetSourceControlUrl(v string) {
	x.xxx_hidden_SourceControlUrl = v
}

func (x *Commit) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Commit) HasDigest() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Digest != nil
}

func (x *Commit) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Commit) ClearDigest() {
	x.xxx_hidden_Digest = nil
}

type Commit_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id of the Commit.
	Id string
	// The time the Commit was pushed to the BSR.
	//
	// Commits are immutable, so there is no corresponding update_time.
	CreateTime *timestamppb.Timestamp
	// The id of the User or Organization that owns the Module that the Commit is associated with.
	OwnerId string
	// The id of the Module that the Commit is associated with.
	ModuleId string
	// The Digest of the Commit's contents.
	//
	// Note that individual RPCs may request a specific DigestType, and a Digest of
	// this DigestType will be returned as part of this Commit. This may affect your
	// caching of returned Commit messages if you require different DigestTypes.
	Digest *Digest
	// The id of the User that created this Commit on the BSR.
	//
	// May be empty if the User is no longer available.
	CreatedByUserId string
	// The URL of the source control commit that is associated with the Commit.
	//
	// BSR users can navigate to this link to find source control information that is relevant to this Commit
	// (e.g. commit description, PR discussion, authors, approvers, etc.).
	SourceControlUrl string
}

func (b0 Commit_builder) Build() *Commit {
	m0 := &Commit{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_ModuleId = b.ModuleId
	x.xxx_hidden_Digest = b.Digest
	x.xxx_hidden_CreatedByUserId = b.CreatedByUserId
	x.xxx_hidden_SourceControlUrl = b.SourceControlUrl
	return m0
}

var File_buf_registry_module_v1_commit_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1_commit_proto_rawDesc = "" +
	"\n" +
	"#buf/registry/module/v1/commit.proto\x12\x16buf.registry.module.v1\x1a#buf/registry/module/v1/digest.proto\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xfc\x02\n" +
	"\x06Commit\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12&\n" +
	"\bowner_id\x18\x03 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\aownerId\x12(\n" +
	"\tmodule_id\x18\x04 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\bmoduleId\x12>\n" +
	"\x06digest\x18\x05 \x01(\v2\x1e.buf.registry.module.v1.DigestB\x06\xbaH\x03\xc8\x01\x01R\x06digest\x128\n" +
	"\x12created_by_user_id\x18\x06 \x01(\tB\v\xbaH\b\xd8\x01\x01r\x03\x88\x02\x01R\x0fcreatedByUserId\x12<\n" +
	"\x12source_control_url\x18\a \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x10sourceControlUrl:\x06\xea\xc5+\x02\x10\x01BWZUbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1;modulev1b\x06proto3"

var file_buf_registry_module_v1_commit_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_registry_module_v1_commit_proto_goTypes = []any{
	(*Commit)(nil),                // 0: buf.registry.module.v1.Commit
	(*timestamppb.Timestamp)(nil), // 1: google.protobuf.Timestamp
	(*Digest)(nil),                // 2: buf.registry.module.v1.Digest
}
var file_buf_registry_module_v1_commit_proto_depIdxs = []int32{
	1, // 0: buf.registry.module.v1.Commit.create_time:type_name -> google.protobuf.Timestamp
	2, // 1: buf.registry.module.v1.Commit.digest:type_name -> buf.registry.module.v1.Digest
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_commit_proto_init() }
func file_buf_registry_module_v1_commit_proto_init() {
	if File_buf_registry_module_v1_commit_proto != nil {
		return
	}
	file_buf_registry_module_v1_digest_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1_commit_proto_rawDesc), len(file_buf_registry_module_v1_commit_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_module_v1_commit_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_commit_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1_commit_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_commit_proto = out.File
	file_buf_registry_module_v1_commit_proto_goTypes = nil
	file_buf_registry_module_v1_commit_proto_depIdxs = nil
}
