// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/owner/v1/user.proto

//go:build protoopaque

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the a User, either active or inactive.
type UserState int32

const (
	UserState_USER_STATE_UNSPECIFIED UserState = 0
	UserState_USER_STATE_ACTIVE      UserState = 1
	UserState_USER_STATE_INACTIVE    UserState = 2
)

// Enum value maps for UserState.
var (
	UserState_name = map[int32]string{
		0: "USER_STATE_UNSPECIFIED",
		1: "USER_STATE_ACTIVE",
		2: "USER_STATE_INACTIVE",
	}
	UserState_value = map[string]int32{
		"USER_STATE_UNSPECIFIED": 0,
		"USER_STATE_ACTIVE":      1,
		"USER_STATE_INACTIVE":    2,
	}
)

func (x UserState) Enum() *UserState {
	p := new(UserState)
	*p = x
	return p
}

func (x UserState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserState) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_user_proto_enumTypes[0].Descriptor()
}

func (UserState) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_user_proto_enumTypes[0]
}

func (x UserState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The type of a User.
type UserType int32

const (
	UserType_USER_TYPE_UNSPECIFIED UserType = 0
	// Users that are standard users.
	UserType_USER_TYPE_STANDARD UserType = 1
	// Users that are bots.
	UserType_USER_TYPE_BOT UserType = 2
	// Users that are internal system users.
	UserType_USER_TYPE_SYSTEM UserType = 3
)

// Enum value maps for UserType.
var (
	UserType_name = map[int32]string{
		0: "USER_TYPE_UNSPECIFIED",
		1: "USER_TYPE_STANDARD",
		2: "USER_TYPE_BOT",
		3: "USER_TYPE_SYSTEM",
	}
	UserType_value = map[string]int32{
		"USER_TYPE_UNSPECIFIED": 0,
		"USER_TYPE_STANDARD":    1,
		"USER_TYPE_BOT":         2,
		"USER_TYPE_SYSTEM":      3,
	}
)

func (x UserType) Enum() *UserType {
	p := new(UserType)
	*p = x
	return p
}

func (x UserType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_user_proto_enumTypes[1].Descriptor()
}

func (UserType) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_user_proto_enumTypes[1]
}

func (x UserType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The verification status of an User.
type UserVerificationStatus int32

const (
	UserVerificationStatus_USER_VERIFICATION_STATUS_UNSPECIFIED UserVerificationStatus = 0
	// The User is unverified.
	UserVerificationStatus_USER_VERIFICATION_STATUS_UNVERIFIED UserVerificationStatus = 1
	// The User is verified.
	UserVerificationStatus_USER_VERIFICATION_STATUS_VERIFIED UserVerificationStatus = 2
	// The User is an official user of the BSR owner.
	UserVerificationStatus_USER_VERIFICATION_STATUS_OFFICIAL UserVerificationStatus = 3
)

// Enum value maps for UserVerificationStatus.
var (
	UserVerificationStatus_name = map[int32]string{
		0: "USER_VERIFICATION_STATUS_UNSPECIFIED",
		1: "USER_VERIFICATION_STATUS_UNVERIFIED",
		2: "USER_VERIFICATION_STATUS_VERIFIED",
		3: "USER_VERIFICATION_STATUS_OFFICIAL",
	}
	UserVerificationStatus_value = map[string]int32{
		"USER_VERIFICATION_STATUS_UNSPECIFIED": 0,
		"USER_VERIFICATION_STATUS_UNVERIFIED":  1,
		"USER_VERIFICATION_STATUS_VERIFIED":    2,
		"USER_VERIFICATION_STATUS_OFFICIAL":    3,
	}
)

func (x UserVerificationStatus) Enum() *UserVerificationStatus {
	p := new(UserVerificationStatus)
	*p = x
	return p
}

func (x UserVerificationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserVerificationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_user_proto_enumTypes[2].Descriptor()
}

func (UserVerificationStatus) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_user_proto_enumTypes[2]
}

func (x UserVerificationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// A user on the BSR.
//
// A name uniquely identifies a User, however name is mutable.
type User struct {
	state                         protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id                 string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime         *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime         *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Name               string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_Type               UserType               `protobuf:"varint,5,opt,name=type,proto3,enum=buf.registry.owner.v1.UserType"`
	xxx_hidden_State              UserState              `protobuf:"varint,6,opt,name=state,proto3,enum=buf.registry.owner.v1.UserState"`
	xxx_hidden_Description        string                 `protobuf:"bytes,7,opt,name=description,proto3"`
	xxx_hidden_Url                string                 `protobuf:"bytes,8,opt,name=url,proto3"`
	xxx_hidden_VerificationStatus UserVerificationStatus `protobuf:"varint,9,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.UserVerificationStatus"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *User) Reset() {
	*x = User{}
	mi := &file_buf_registry_owner_v1_user_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *User) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*User) ProtoMessage() {}

func (x *User) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *User) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *User) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *User) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *User) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *User) GetType() UserType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return UserType_USER_TYPE_UNSPECIFIED
}

func (x *User) GetState() UserState {
	if x != nil {
		return x.xxx_hidden_State
	}
	return UserState_USER_STATE_UNSPECIFIED
}

func (x *User) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *User) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *User) GetVerificationStatus() UserVerificationStatus {
	if x != nil {
		return x.xxx_hidden_VerificationStatus
	}
	return UserVerificationStatus_USER_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *User) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *User) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *User) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *User) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *User) SetType(v UserType) {
	x.xxx_hidden_Type = v
}

func (x *User) SetState(v UserState) {
	x.xxx_hidden_State = v
}

func (x *User) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *User) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *User) SetVerificationStatus(v UserVerificationStatus) {
	x.xxx_hidden_VerificationStatus = v
}

func (x *User) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *User) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *User) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *User) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

type User_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id for the User.
	Id string
	// The time the User was created.
	CreateTime *timestamppb.Timestamp
	// The last time the User was updated.
	UpdateTime *timestamppb.Timestamp
	// The name of the User.
	//
	// A name uniquely identifies a User, however name is mutable.
	Name string
	// The type of the User.
	Type UserType
	// The state of the User.
	State UserState
	// The configurable description of the User.
	Description string
	// The configurable URL that represents the homepage for a User.
	Url string
	// The verification status of the User.
	VerificationStatus UserVerificationStatus
}

func (b0 User_builder) Build() *User {
	m0 := &User{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_State = b.State
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_VerificationStatus = b.VerificationStatus
	return m0
}

// UserRef is a reference to a User, either an id or a name.
//
// This is used in requests.
type UserRef struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value isUserRef_Value        `protobuf_oneof:"value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UserRef) Reset() {
	*x = UserRef{}
	mi := &file_buf_registry_owner_v1_user_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserRef) ProtoMessage() {}

func (x *UserRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UserRef) GetId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*userRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *UserRef) GetName() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*userRef_Name); ok {
			return x.Name
		}
	}
	return ""
}

func (x *UserRef) SetId(v string) {
	x.xxx_hidden_Value = &userRef_Id{v}
}

func (x *UserRef) SetName(v string) {
	x.xxx_hidden_Value = &userRef_Name{v}
}

func (x *UserRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *UserRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*userRef_Id)
	return ok
}

func (x *UserRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*userRef_Name)
	return ok
}

func (x *UserRef) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *UserRef) ClearId() {
	if _, ok := x.xxx_hidden_Value.(*userRef_Id); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *UserRef) ClearName() {
	if _, ok := x.xxx_hidden_Value.(*userRef_Name); ok {
		x.xxx_hidden_Value = nil
	}
}

const UserRef_Value_not_set_case case_UserRef_Value = 0
const UserRef_Id_case case_UserRef_Value = 1
const UserRef_Name_case case_UserRef_Value = 2

func (x *UserRef) WhichValue() case_UserRef_Value {
	if x == nil {
		return UserRef_Value_not_set_case
	}
	switch x.xxx_hidden_Value.(type) {
	case *userRef_Id:
		return UserRef_Id_case
	case *userRef_Name:
		return UserRef_Name_case
	default:
		return UserRef_Value_not_set_case
	}
}

type UserRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Value:
	// The id of the User.
	Id *string
	// The name of the User.
	Name *string
	// -- end of xxx_hidden_Value
}

func (b0 UserRef_builder) Build() *UserRef {
	m0 := &UserRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.xxx_hidden_Value = &userRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.xxx_hidden_Value = &userRef_Name{*b.Name}
	}
	return m0
}

type case_UserRef_Value protoreflect.FieldNumber

func (x case_UserRef_Value) String() string {
	md := file_buf_registry_owner_v1_user_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isUserRef_Value interface {
	isUserRef_Value()
}

type userRef_Id struct {
	// The id of the User.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type userRef_Name struct {
	// The name of the User.
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*userRef_Id) isUserRef_Value() {}

func (*userRef_Name) isUserRef_Value() {}

var File_buf_registry_owner_v1_user_proto protoreflect.FileDescriptor

const file_buf_registry_owner_v1_user_proto_rawDesc = "" +
	"\n" +
	" buf/registry/owner/v1/user.proto\x12\x15buf.registry.owner.v1\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xb4\x04\n" +
	"\x04User\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12C\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"updateTime\x12;\n" +
	"\x04name\x18\x04 \x01(\tB'\xbaH$\xc8\x01\x01r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$R\x04name\x12@\n" +
	"\x04type\x18\x05 \x01(\x0e2\x1f.buf.registry.owner.v1.UserTypeB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x04type\x12C\n" +
	"\x05state\x18\x06 \x01(\x0e2 .buf.registry.owner.v1.UserStateB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x05state\x12*\n" +
	"\vdescription\x18\a \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12 \n" +
	"\x03url\x18\b \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x03url\x12k\n" +
	"\x13verification_status\x18\t \x01(\x0e2-.buf.registry.owner.v1.UserVerificationStatusB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x12verificationStatus:\x06\xea\xc5+\x02\x10\x01\"y\n" +
	"\aUserRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12:\n" +
	"\x04name\x18\x02 \x01(\tB$\xbaH!r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$H\x00R\x04name:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01*W\n" +
	"\tUserState\x12\x1a\n" +
	"\x16USER_STATE_UNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11USER_STATE_ACTIVE\x10\x01\x12\x17\n" +
	"\x13USER_STATE_INACTIVE\x10\x02*f\n" +
	"\bUserType\x12\x19\n" +
	"\x15USER_TYPE_UNSPECIFIED\x10\x00\x12\x16\n" +
	"\x12USER_TYPE_STANDARD\x10\x01\x12\x11\n" +
	"\rUSER_TYPE_BOT\x10\x02\x12\x14\n" +
	"\x10USER_TYPE_SYSTEM\x10\x03*\xb9\x01\n" +
	"\x16UserVerificationStatus\x12(\n" +
	"$USER_VERIFICATION_STATUS_UNSPECIFIED\x10\x00\x12'\n" +
	"#USER_VERIFICATION_STATUS_UNVERIFIED\x10\x01\x12%\n" +
	"!USER_VERIFICATION_STATUS_VERIFIED\x10\x02\x12%\n" +
	"!USER_VERIFICATION_STATUS_OFFICIAL\x10\x03BUZSbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1;ownerv1b\x06proto3"

var file_buf_registry_owner_v1_user_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_registry_owner_v1_user_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_buf_registry_owner_v1_user_proto_goTypes = []any{
	(UserState)(0),                // 0: buf.registry.owner.v1.UserState
	(UserType)(0),                 // 1: buf.registry.owner.v1.UserType
	(UserVerificationStatus)(0),   // 2: buf.registry.owner.v1.UserVerificationStatus
	(*User)(nil),                  // 3: buf.registry.owner.v1.User
	(*UserRef)(nil),               // 4: buf.registry.owner.v1.UserRef
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_buf_registry_owner_v1_user_proto_depIdxs = []int32{
	5, // 0: buf.registry.owner.v1.User.create_time:type_name -> google.protobuf.Timestamp
	5, // 1: buf.registry.owner.v1.User.update_time:type_name -> google.protobuf.Timestamp
	1, // 2: buf.registry.owner.v1.User.type:type_name -> buf.registry.owner.v1.UserType
	0, // 3: buf.registry.owner.v1.User.state:type_name -> buf.registry.owner.v1.UserState
	2, // 4: buf.registry.owner.v1.User.verification_status:type_name -> buf.registry.owner.v1.UserVerificationStatus
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_user_proto_init() }
func file_buf_registry_owner_v1_user_proto_init() {
	if File_buf_registry_owner_v1_user_proto != nil {
		return
	}
	file_buf_registry_owner_v1_user_proto_msgTypes[1].OneofWrappers = []any{
		(*userRef_Id)(nil),
		(*userRef_Name)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_owner_v1_user_proto_rawDesc), len(file_buf_registry_owner_v1_user_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_owner_v1_user_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_user_proto_depIdxs,
		EnumInfos:         file_buf_registry_owner_v1_user_proto_enumTypes,
		MessageInfos:      file_buf_registry_owner_v1_user_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_user_proto = out.File
	file_buf_registry_owner_v1_user_proto_goTypes = nil
	file_buf_registry_owner_v1_user_proto_depIdxs = nil
}
