// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/policy/v1beta1/policy.proto

//go:build !protoopaque

package policyv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The visibility of a Policy, currently either public or private.
type PolicyVisibility int32

const (
	PolicyVisibility_POLICY_VISIBILITY_UNSPECIFIED PolicyVisibility = 0
	// POLICY_VISIBILITY_PUBLIC says that the Policy is publicly available.
	PolicyVisibility_POLICY_VISIBILITY_PUBLIC PolicyVisibility = 1
	// POLICY_VISIBILITY_PRIVATE says that the Policy is private.
	PolicyVisibility_POLICY_VISIBILITY_PRIVATE PolicyVisibility = 2
)

// Enum value maps for PolicyVisibility.
var (
	PolicyVisibility_name = map[int32]string{
		0: "POLICY_VISIBILITY_UNSPECIFIED",
		1: "POLICY_VISIBILITY_PUBLIC",
		2: "POLICY_VISIBILITY_PRIVATE",
	}
	PolicyVisibility_value = map[string]int32{
		"POLICY_VISIBILITY_UNSPECIFIED": 0,
		"POLICY_VISIBILITY_PUBLIC":      1,
		"POLICY_VISIBILITY_PRIVATE":     2,
	}
)

func (x PolicyVisibility) Enum() *PolicyVisibility {
	p := new(PolicyVisibility)
	*p = x
	return p
}

func (x PolicyVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_policy_v1beta1_policy_proto_enumTypes[0].Descriptor()
}

func (PolicyVisibility) Type() protoreflect.EnumType {
	return &file_buf_registry_policy_v1beta1_policy_proto_enumTypes[0]
}

func (x PolicyVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The state of a Policy, currently either active or deprecated.
type PolicyState int32

const (
	PolicyState_POLICY_STATE_UNSPECIFIED PolicyState = 0
	// POLICY_STATE_ACTIVE says that the Policy is currently active.
	PolicyState_POLICY_STATE_ACTIVE PolicyState = 1
	// POLICY_STATE_DEPRECATED says that the Policy has been deprecated and should not longer be
	// used.
	PolicyState_POLICY_STATE_DEPRECATED PolicyState = 2
)

// Enum value maps for PolicyState.
var (
	PolicyState_name = map[int32]string{
		0: "POLICY_STATE_UNSPECIFIED",
		1: "POLICY_STATE_ACTIVE",
		2: "POLICY_STATE_DEPRECATED",
	}
	PolicyState_value = map[string]int32{
		"POLICY_STATE_UNSPECIFIED": 0,
		"POLICY_STATE_ACTIVE":      1,
		"POLICY_STATE_DEPRECATED":  2,
	}
)

func (x PolicyState) Enum() *PolicyState {
	p := new(PolicyState)
	*p = x
	return p
}

func (x PolicyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyState) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_policy_v1beta1_policy_proto_enumTypes[1].Descriptor()
}

func (PolicyState) Type() protoreflect.EnumType {
	return &file_buf_registry_policy_v1beta1_policy_proto_enumTypes[1]
}

func (x PolicyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// A policy within the BSR.
type Policy struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The id of the Policy.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The time the Policy was created in the BSR.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last time the Policy was updated on the BSR.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The name of the Policy.
	//
	// Unique within a given Organization.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the Organization that owns the Policy.
	OwnerId string `protobuf:"bytes,5,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// The Policy's visibility, either public or private.
	Visibility PolicyVisibility `protobuf:"varint,6,opt,name=visibility,proto3,enum=buf.registry.policy.v1beta1.PolicyVisibility" json:"visibility,omitempty"`
	// The Policy state, either active or deprecated.
	State PolicyState `protobuf:"varint,7,opt,name=state,proto3,enum=buf.registry.policy.v1beta1.PolicyState" json:"state,omitempty"`
	// The configurable description of the Policy.
	Description   string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Policy) Reset() {
	*x = Policy{}
	mi := &file_buf_registry_policy_v1beta1_policy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Policy) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Policy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Policy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Policy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Policy) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *Policy) GetVisibility() PolicyVisibility {
	if x != nil {
		return x.Visibility
	}
	return PolicyVisibility_POLICY_VISIBILITY_UNSPECIFIED
}

func (x *Policy) GetState() PolicyState {
	if x != nil {
		return x.State
	}
	return PolicyState_POLICY_STATE_UNSPECIFIED
}

func (x *Policy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Policy) SetId(v string) {
	x.Id = v
}

func (x *Policy) SetCreateTime(v *timestamppb.Timestamp) {
	x.CreateTime = v
}

func (x *Policy) SetUpdateTime(v *timestamppb.Timestamp) {
	x.UpdateTime = v
}

func (x *Policy) SetName(v string) {
	x.Name = v
}

func (x *Policy) SetOwnerId(v string) {
	x.OwnerId = v
}

func (x *Policy) SetVisibility(v PolicyVisibility) {
	x.Visibility = v
}

func (x *Policy) SetState(v PolicyState) {
	x.State = v
}

func (x *Policy) SetDescription(v string) {
	x.Description = v
}

func (x *Policy) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.CreateTime != nil
}

func (x *Policy) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.UpdateTime != nil
}

func (x *Policy) ClearCreateTime() {
	x.CreateTime = nil
}

func (x *Policy) ClearUpdateTime() {
	x.UpdateTime = nil
}

type Policy_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id of the Policy.
	Id string
	// The time the Policy was created in the BSR.
	CreateTime *timestamppb.Timestamp
	// The last time the Policy was updated on the BSR.
	UpdateTime *timestamppb.Timestamp
	// The name of the Policy.
	//
	// Unique within a given Organization.
	Name string
	// The id of the Organization that owns the Policy.
	OwnerId string
	// The Policy's visibility, either public or private.
	Visibility PolicyVisibility
	// The Policy state, either active or deprecated.
	State PolicyState
	// The configurable description of the Policy.
	Description string
}

func (b0 Policy_builder) Build() *Policy {
	m0 := &Policy{}
	b, x := &b0, m0
	_, _ = b, x
	x.Id = b.Id
	x.CreateTime = b.CreateTime
	x.UpdateTime = b.UpdateTime
	x.Name = b.Name
	x.OwnerId = b.OwnerId
	x.Visibility = b.Visibility
	x.State = b.State
	x.Description = b.Description
	return m0
}

// PolicyRef is a reference to a Policy, either an id or a fully-qualified name.
//
// This is used in requests.
type PolicyRef struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*PolicyRef_Id
	//	*PolicyRef_Name_
	Value         isPolicyRef_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PolicyRef) Reset() {
	*x = PolicyRef{}
	mi := &file_buf_registry_policy_v1beta1_policy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyRef) ProtoMessage() {}

func (x *PolicyRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyRef) GetValue() isPolicyRef_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PolicyRef) GetId() string {
	if x != nil {
		if x, ok := x.Value.(*PolicyRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *PolicyRef) GetName() *PolicyRef_Name {
	if x != nil {
		if x, ok := x.Value.(*PolicyRef_Name_); ok {
			return x.Name
		}
	}
	return nil
}

func (x *PolicyRef) SetId(v string) {
	x.Value = &PolicyRef_Id{v}
}

func (x *PolicyRef) SetName(v *PolicyRef_Name) {
	if v == nil {
		x.Value = nil
		return
	}
	x.Value = &PolicyRef_Name_{v}
}

func (x *PolicyRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *PolicyRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*PolicyRef_Id)
	return ok
}

func (x *PolicyRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*PolicyRef_Name_)
	return ok
}

func (x *PolicyRef) ClearValue() {
	x.Value = nil
}

func (x *PolicyRef) ClearId() {
	if _, ok := x.Value.(*PolicyRef_Id); ok {
		x.Value = nil
	}
}

func (x *PolicyRef) ClearName() {
	if _, ok := x.Value.(*PolicyRef_Name_); ok {
		x.Value = nil
	}
}

const PolicyRef_Value_not_set_case case_PolicyRef_Value = 0
const PolicyRef_Id_case case_PolicyRef_Value = 1
const PolicyRef_Name_case case_PolicyRef_Value = 2

func (x *PolicyRef) WhichValue() case_PolicyRef_Value {
	if x == nil {
		return PolicyRef_Value_not_set_case
	}
	switch x.Value.(type) {
	case *PolicyRef_Id:
		return PolicyRef_Id_case
	case *PolicyRef_Name_:
		return PolicyRef_Name_case
	default:
		return PolicyRef_Value_not_set_case
	}
}

type PolicyRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Value:
	// The id of the Policy.
	Id *string
	// The full-qualified name of the Policy.
	Name *PolicyRef_Name
	// -- end of Value
}

func (b0 PolicyRef_builder) Build() *PolicyRef {
	m0 := &PolicyRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.Value = &PolicyRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.Value = &PolicyRef_Name_{b.Name}
	}
	return m0
}

type case_PolicyRef_Value protoreflect.FieldNumber

func (x case_PolicyRef_Value) String() string {
	md := file_buf_registry_policy_v1beta1_policy_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isPolicyRef_Value interface {
	isPolicyRef_Value()
}

type PolicyRef_Id struct {
	// The id of the Policy.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type PolicyRef_Name_ struct {
	// The full-qualified name of the Policy.
	Name *PolicyRef_Name `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*PolicyRef_Id) isPolicyRef_Value() {}

func (*PolicyRef_Name_) isPolicyRef_Value() {}

// The fully-qualified name of a Policy within a BSR intance.
//
// A Name uniquely identifies a Policy.
// This is used for requests when a caller only has the policy name and not the ID.
type PolicyRef_Name struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The name of the owner of the Policy. The owner is always an Organization.
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the Policy.
	Policy        string `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PolicyRef_Name) Reset() {
	*x = PolicyRef_Name{}
	mi := &file_buf_registry_policy_v1beta1_policy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyRef_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyRef_Name) ProtoMessage() {}

func (x *PolicyRef_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_policy_v1beta1_policy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PolicyRef_Name) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *PolicyRef_Name) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *PolicyRef_Name) SetOwner(v string) {
	x.Owner = v
}

func (x *PolicyRef_Name) SetPolicy(v string) {
	x.Policy = v
}

type PolicyRef_Name_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the owner of the Policy. The owner is always an Organization.
	Owner string
	// The name of the Policy.
	Policy string
}

func (b0 PolicyRef_Name_builder) Build() *PolicyRef_Name {
	m0 := &PolicyRef_Name{}
	b, x := &b0, m0
	_, _ = b, x
	x.Owner = b.Owner
	x.Policy = b.Policy
	return m0
}

var File_buf_registry_policy_v1beta1_policy_proto protoreflect.FileDescriptor

const file_buf_registry_policy_v1beta1_policy_proto_rawDesc = "" +
	"\n" +
	"(buf/registry/policy/v1beta1/policy.proto\x12\x1bbuf.registry.policy.v1beta1\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xd3\x03\n" +
	"\x06Policy\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12C\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"updateTime\x12\x1d\n" +
	"\x04name\x18\x04 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x04name\x12&\n" +
	"\bowner_id\x18\x05 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\aownerId\x12Z\n" +
	"\n" +
	"visibility\x18\x06 \x01(\x0e2-.buf.registry.policy.v1beta1.PolicyVisibilityB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\n" +
	"visibility\x12K\n" +
	"\x05state\x18\a \x01(\x0e2(.buf.registry.policy.v1beta1.PolicyStateB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x05state\x12*\n" +
	"\vdescription\x18\b \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription:\x06\xea\xc5+\x02\x10\x01\"\xcf\x01\n" +
	"\tPolicyRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12A\n" +
	"\x04name\x18\x02 \x01(\v2+.buf.registry.policy.v1beta1.PolicyRef.NameH\x00R\x04name\x1aK\n" +
	"\x04Name\x12 \n" +
	"\x05owner\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x18 R\x05owner\x12!\n" +
	"\x06policy\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x06policy:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01*r\n" +
	"\x10PolicyVisibility\x12!\n" +
	"\x1dPOLICY_VISIBILITY_UNSPECIFIED\x10\x00\x12\x1c\n" +
	"\x18POLICY_VISIBILITY_PUBLIC\x10\x01\x12\x1d\n" +
	"\x19POLICY_VISIBILITY_PRIVATE\x10\x02*a\n" +
	"\vPolicyState\x12\x1c\n" +
	"\x18POLICY_STATE_UNSPECIFIED\x10\x00\x12\x17\n" +
	"\x13POLICY_STATE_ACTIVE\x10\x01\x12\x1b\n" +
	"\x17POLICY_STATE_DEPRECATED\x10\x02BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/policy/v1beta1;policyv1beta1b\x06proto3"

var file_buf_registry_policy_v1beta1_policy_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_registry_policy_v1beta1_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_policy_v1beta1_policy_proto_goTypes = []any{
	(PolicyVisibility)(0),         // 0: buf.registry.policy.v1beta1.PolicyVisibility
	(PolicyState)(0),              // 1: buf.registry.policy.v1beta1.PolicyState
	(*Policy)(nil),                // 2: buf.registry.policy.v1beta1.Policy
	(*PolicyRef)(nil),             // 3: buf.registry.policy.v1beta1.PolicyRef
	(*PolicyRef_Name)(nil),        // 4: buf.registry.policy.v1beta1.PolicyRef.Name
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_buf_registry_policy_v1beta1_policy_proto_depIdxs = []int32{
	5, // 0: buf.registry.policy.v1beta1.Policy.create_time:type_name -> google.protobuf.Timestamp
	5, // 1: buf.registry.policy.v1beta1.Policy.update_time:type_name -> google.protobuf.Timestamp
	0, // 2: buf.registry.policy.v1beta1.Policy.visibility:type_name -> buf.registry.policy.v1beta1.PolicyVisibility
	1, // 3: buf.registry.policy.v1beta1.Policy.state:type_name -> buf.registry.policy.v1beta1.PolicyState
	4, // 4: buf.registry.policy.v1beta1.PolicyRef.name:type_name -> buf.registry.policy.v1beta1.PolicyRef.Name
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_registry_policy_v1beta1_policy_proto_init() }
func file_buf_registry_policy_v1beta1_policy_proto_init() {
	if File_buf_registry_policy_v1beta1_policy_proto != nil {
		return
	}
	file_buf_registry_policy_v1beta1_policy_proto_msgTypes[1].OneofWrappers = []any{
		(*PolicyRef_Id)(nil),
		(*PolicyRef_Name_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_policy_v1beta1_policy_proto_rawDesc), len(file_buf_registry_policy_v1beta1_policy_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_policy_v1beta1_policy_proto_goTypes,
		DependencyIndexes: file_buf_registry_policy_v1beta1_policy_proto_depIdxs,
		EnumInfos:         file_buf_registry_policy_v1beta1_policy_proto_enumTypes,
		MessageInfos:      file_buf_registry_policy_v1beta1_policy_proto_msgTypes,
	}.Build()
	File_buf_registry_policy_v1beta1_policy_proto = out.File
	file_buf_registry_policy_v1beta1_policy_proto_goTypes = nil
	file_buf_registry_policy_v1beta1_policy_proto_depIdxs = nil
}
