// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/upload_service.proto

//go:build !protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type UploadRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Contents of all references.
	Contents      []*UploadRequest_Content `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UploadRequest) Reset() {
	*x = UploadRequest{}
	mi := &file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest) ProtoMessage() {}

func (x *UploadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UploadRequest) GetContents() []*UploadRequest_Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *UploadRequest) SetContents(v []*UploadRequest_Content) {
	x.Contents = v
}

type UploadRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Contents of all references.
	Contents []*UploadRequest_Content
}

func (b0 UploadRequest_builder) Build() *UploadRequest {
	m0 := &UploadRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Contents = b.Contents
	return m0
}

type UploadResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Commits       []*Commit              `protobuf:"bytes,1,rep,name=commits,proto3" json:"commits,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UploadResponse) Reset() {
	*x = UploadResponse{}
	mi := &file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadResponse) ProtoMessage() {}

func (x *UploadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UploadResponse) GetCommits() []*Commit {
	if x != nil {
		return x.Commits
	}
	return nil
}

func (x *UploadResponse) SetCommits(v []*Commit) {
	x.Commits = v
}

type UploadResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Commits []*Commit
}

func (b0 UploadResponse_builder) Build() *UploadResponse {
	m0 := &UploadResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Commits = b.Commits
	return m0
}

// Content to upload.
type UploadRequest_Content struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Plugin of the reference.
	PluginRef *PluginRef `protobuf:"bytes,1,opt,name=plugin_ref,json=pluginRef,proto3" json:"plugin_ref,omitempty"`
	// Compression type of the content.
	CompressionType CompressionType `protobuf:"varint,2,opt,name=compression_type,json=compressionType,proto3,enum=buf.registry.plugin.v1beta1.CompressionType" json:"compression_type,omitempty"`
	// The content to upload.
	Content []byte `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
	// The labels to associate with the Commit for the Content.
	//
	// If an id is set, this id must represent a Label that already exists and is
	// owned by the Plugin. The Label will point to the newly-created Commits for the References,
	// or will be updated to point to the pre-existing Commit for the Reference.
	//
	// If no labels are referenced, the default Label for the Plugin is used.
	//
	// If the Labels do not exist, they will be created. If the Labels were archived, they will be
	// unarchived.
	ScopedLabelRefs []*ScopedLabelRef `protobuf:"bytes,4,rep,name=scoped_label_refs,json=scopedLabelRefs,proto3" json:"scoped_label_refs,omitempty"`
	// The URL of the source control commit to associate with the Commit for this Content.
	//
	// BSR users can navigate to this link to find source control information that is relevant to
	// this Commit (e.g. commit description, PR discussion, authors, approvers, etc.).
	SourceControlUrl string `protobuf:"bytes,5,opt,name=source_control_url,json=sourceControlUrl,proto3" json:"source_control_url,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *UploadRequest_Content) Reset() {
	*x = UploadRequest_Content{}
	mi := &file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadRequest_Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRequest_Content) ProtoMessage() {}

func (x *UploadRequest_Content) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UploadRequest_Content) GetPluginRef() *PluginRef {
	if x != nil {
		return x.PluginRef
	}
	return nil
}

func (x *UploadRequest_Content) GetCompressionType() CompressionType {
	if x != nil {
		return x.CompressionType
	}
	return CompressionType_COMPRESSION_TYPE_UNSPECIFIED
}

func (x *UploadRequest_Content) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *UploadRequest_Content) GetScopedLabelRefs() []*ScopedLabelRef {
	if x != nil {
		return x.ScopedLabelRefs
	}
	return nil
}

func (x *UploadRequest_Content) GetSourceControlUrl() string {
	if x != nil {
		return x.SourceControlUrl
	}
	return ""
}

func (x *UploadRequest_Content) SetPluginRef(v *PluginRef) {
	x.PluginRef = v
}

func (x *UploadRequest_Content) SetCompressionType(v CompressionType) {
	x.CompressionType = v
}

func (x *UploadRequest_Content) SetContent(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Content = v
}

func (x *UploadRequest_Content) SetScopedLabelRefs(v []*ScopedLabelRef) {
	x.ScopedLabelRefs = v
}

func (x *UploadRequest_Content) SetSourceControlUrl(v string) {
	x.SourceControlUrl = v
}

func (x *UploadRequest_Content) HasPluginRef() bool {
	if x == nil {
		return false
	}
	return x.PluginRef != nil
}

func (x *UploadRequest_Content) ClearPluginRef() {
	x.PluginRef = nil
}

type UploadRequest_Content_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Plugin of the reference.
	PluginRef *PluginRef
	// Compression type of the content.
	CompressionType CompressionType
	// The content to upload.
	Content []byte
	// The labels to associate with the Commit for the Content.
	//
	// If an id is set, this id must represent a Label that already exists and is
	// owned by the Plugin. The Label will point to the newly-created Commits for the References,
	// or will be updated to point to the pre-existing Commit for the Reference.
	//
	// If no labels are referenced, the default Label for the Plugin is used.
	//
	// If the Labels do not exist, they will be created. If the Labels were archived, they will be
	// unarchived.
	ScopedLabelRefs []*ScopedLabelRef
	// The URL of the source control commit to associate with the Commit for this Content.
	//
	// BSR users can navigate to this link to find source control information that is relevant to
	// this Commit (e.g. commit description, PR discussion, authors, approvers, etc.).
	SourceControlUrl string
}

func (b0 UploadRequest_Content_builder) Build() *UploadRequest_Content {
	m0 := &UploadRequest_Content{}
	b, x := &b0, m0
	_, _ = b, x
	x.PluginRef = b.PluginRef
	x.CompressionType = b.CompressionType
	x.Content = b.Content
	x.ScopedLabelRefs = b.ScopedLabelRefs
	x.SourceControlUrl = b.SourceControlUrl
	return m0
}

var File_buf_registry_plugin_v1beta1_upload_service_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_upload_service_proto_rawDesc = "" +
	"\n" +
	"0buf/registry/plugin/v1beta1/upload_service.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a(buf/registry/plugin/v1beta1/commit.proto\x1a-buf/registry/plugin/v1beta1/compression.proto\x1a'buf/registry/plugin/v1beta1/label.proto\x1a(buf/registry/plugin/v1beta1/plugin.proto\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\"\xed\x03\n" +
	"\rUploadRequest\x12Z\n" +
	"\bcontents\x18\x01 \x03(\v22.buf.registry.plugin.v1beta1.UploadRequest.ContentB\n" +
	"\xbaH\a\x92\x01\x04\b\x01\x10\n" +
	"R\bcontents\x1a\xf7\x02\n" +
	"\aContent\x12M\n" +
	"\n" +
	"plugin_ref\x18\x01 \x01(\v2&.buf.registry.plugin.v1beta1.PluginRefB\x06\xbaH\x03\xc8\x01\x01R\tpluginRef\x12d\n" +
	"\x10compression_type\x18\x02 \x01(\x0e2,.buf.registry.plugin.v1beta1.CompressionTypeB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x0fcompressionType\x12 \n" +
	"\acontent\x18\x03 \x01(\fB\x06\xbaH\x03\xc8\x01\x01R\acontent\x12W\n" +
	"\x11scoped_label_refs\x18\x04 \x03(\v2+.buf.registry.plugin.v1beta1.ScopedLabelRefR\x0fscopedLabelRefs\x12<\n" +
	"\x12source_control_url\x18\x05 \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x10sourceControlUrl:\x06\xea\xc5+\x02\b\x01\"a\n" +
	"\x0eUploadResponse\x12G\n" +
	"\acommits\x18\x01 \x03(\v2#.buf.registry.plugin.v1beta1.CommitB\b\xbaH\x05\x92\x01\x02\b\x01R\acommits:\x06\xea\xc5+\x02\x10\x012t\n" +
	"\rUploadService\x12c\n" +
	"\x06Upload\x12*.buf.registry.plugin.v1beta1.UploadRequest\x1a+.buf.registry.plugin.v1beta1.UploadResponse\"\x00BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_plugin_v1beta1_upload_service_proto_goTypes = []any{
	(*UploadRequest)(nil),         // 0: buf.registry.plugin.v1beta1.UploadRequest
	(*UploadResponse)(nil),        // 1: buf.registry.plugin.v1beta1.UploadResponse
	(*UploadRequest_Content)(nil), // 2: buf.registry.plugin.v1beta1.UploadRequest.Content
	(*Commit)(nil),                // 3: buf.registry.plugin.v1beta1.Commit
	(*PluginRef)(nil),             // 4: buf.registry.plugin.v1beta1.PluginRef
	(CompressionType)(0),          // 5: buf.registry.plugin.v1beta1.CompressionType
	(*ScopedLabelRef)(nil),        // 6: buf.registry.plugin.v1beta1.ScopedLabelRef
}
var file_buf_registry_plugin_v1beta1_upload_service_proto_depIdxs = []int32{
	2, // 0: buf.registry.plugin.v1beta1.UploadRequest.contents:type_name -> buf.registry.plugin.v1beta1.UploadRequest.Content
	3, // 1: buf.registry.plugin.v1beta1.UploadResponse.commits:type_name -> buf.registry.plugin.v1beta1.Commit
	4, // 2: buf.registry.plugin.v1beta1.UploadRequest.Content.plugin_ref:type_name -> buf.registry.plugin.v1beta1.PluginRef
	5, // 3: buf.registry.plugin.v1beta1.UploadRequest.Content.compression_type:type_name -> buf.registry.plugin.v1beta1.CompressionType
	6, // 4: buf.registry.plugin.v1beta1.UploadRequest.Content.scoped_label_refs:type_name -> buf.registry.plugin.v1beta1.ScopedLabelRef
	0, // 5: buf.registry.plugin.v1beta1.UploadService.Upload:input_type -> buf.registry.plugin.v1beta1.UploadRequest
	1, // 6: buf.registry.plugin.v1beta1.UploadService.Upload:output_type -> buf.registry.plugin.v1beta1.UploadResponse
	6, // [6:7] is the sub-list for method output_type
	5, // [5:6] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_upload_service_proto_init() }
func file_buf_registry_plugin_v1beta1_upload_service_proto_init() {
	if File_buf_registry_plugin_v1beta1_upload_service_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_commit_proto_init()
	file_buf_registry_plugin_v1beta1_compression_proto_init()
	file_buf_registry_plugin_v1beta1_label_proto_init()
	file_buf_registry_plugin_v1beta1_plugin_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_upload_service_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_upload_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_upload_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_upload_service_proto_depIdxs,
		MessageInfos:      file_buf_registry_plugin_v1beta1_upload_service_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_upload_service_proto = out.File
	file_buf_registry_plugin_v1beta1_upload_service_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_upload_service_proto_depIdxs = nil
}
