// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/label.proto

//go:build !protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A label on a specific Plugin.
//
// Many Labels can be associated with one Commit.
type Label struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The id of the Label.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The time the Label was created on the BSR.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last time the Label was updated on the BSR.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The time the Label was archived if it is currently archived.
	//
	// If this field is not set, the Label is not currently archived.
	ArchiveTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=archive_time,json=archiveTime,proto3" json:"archive_time,omitempty"`
	// The name of the Label.
	//
	// Unique within a given Plugin.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// The id of the Organization that owns the Plugin that the Label is associated with.
	OwnerId string `protobuf:"bytes,6,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// The id of the Plugin that the Label is associated with.
	PluginId string `protobuf:"bytes,7,opt,name=plugin_id,json=pluginId,proto3" json:"plugin_id,omitempty"`
	// The id of the Commit currently associated with the Label.
	//
	// To get the history of the Commits that have been associated with a Label, use ListLabelHistory.
	CommitId string `protobuf:"bytes,8,opt,name=commit_id,json=commitId,proto3" json:"commit_id,omitempty"`
	// The id of the User that last updated this Label on the BSR.
	//
	// May be empty if the User is no longer available.
	UpdatedByUserId string `protobuf:"bytes,9,opt,name=updated_by_user_id,json=updatedByUserId,proto3" json:"updated_by_user_id,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Label) Reset() {
	*x = Label{}
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Label) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label) ProtoMessage() {}

func (x *Label) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Label) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Label) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Label) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Label) GetArchiveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ArchiveTime
	}
	return nil
}

func (x *Label) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Label) GetOwnerId() string {
	if x != nil {
		return x.OwnerId
	}
	return ""
}

func (x *Label) GetPluginId() string {
	if x != nil {
		return x.PluginId
	}
	return ""
}

func (x *Label) GetCommitId() string {
	if x != nil {
		return x.CommitId
	}
	return ""
}

func (x *Label) GetUpdatedByUserId() string {
	if x != nil {
		return x.UpdatedByUserId
	}
	return ""
}

func (x *Label) SetId(v string) {
	x.Id = v
}

func (x *Label) SetCreateTime(v *timestamppb.Timestamp) {
	x.CreateTime = v
}

func (x *Label) SetUpdateTime(v *timestamppb.Timestamp) {
	x.UpdateTime = v
}

func (x *Label) SetArchiveTime(v *timestamppb.Timestamp) {
	x.ArchiveTime = v
}

func (x *Label) SetName(v string) {
	x.Name = v
}

func (x *Label) SetOwnerId(v string) {
	x.OwnerId = v
}

func (x *Label) SetPluginId(v string) {
	x.PluginId = v
}

func (x *Label) SetCommitId(v string) {
	x.CommitId = v
}

func (x *Label) SetUpdatedByUserId(v string) {
	x.UpdatedByUserId = v
}

func (x *Label) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.CreateTime != nil
}

func (x *Label) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.UpdateTime != nil
}

func (x *Label) HasArchiveTime() bool {
	if x == nil {
		return false
	}
	return x.ArchiveTime != nil
}

func (x *Label) ClearCreateTime() {
	x.CreateTime = nil
}

func (x *Label) ClearUpdateTime() {
	x.UpdateTime = nil
}

func (x *Label) ClearArchiveTime() {
	x.ArchiveTime = nil
}

type Label_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id of the Label.
	Id string
	// The time the Label was created on the BSR.
	CreateTime *timestamppb.Timestamp
	// The last time the Label was updated on the BSR.
	UpdateTime *timestamppb.Timestamp
	// The time the Label was archived if it is currently archived.
	//
	// If this field is not set, the Label is not currently archived.
	ArchiveTime *timestamppb.Timestamp
	// The name of the Label.
	//
	// Unique within a given Plugin.
	Name string
	// The id of the Organization that owns the Plugin that the Label is associated with.
	OwnerId string
	// The id of the Plugin that the Label is associated with.
	PluginId string
	// The id of the Commit currently associated with the Label.
	//
	// To get the history of the Commits that have been associated with a Label, use ListLabelHistory.
	CommitId string
	// The id of the User that last updated this Label on the BSR.
	//
	// May be empty if the User is no longer available.
	UpdatedByUserId string
}

func (b0 Label_builder) Build() *Label {
	m0 := &Label{}
	b, x := &b0, m0
	_, _ = b, x
	x.Id = b.Id
	x.CreateTime = b.CreateTime
	x.UpdateTime = b.UpdateTime
	x.ArchiveTime = b.ArchiveTime
	x.Name = b.Name
	x.OwnerId = b.OwnerId
	x.PluginId = b.PluginId
	x.CommitId = b.CommitId
	x.UpdatedByUserId = b.UpdatedByUserId
	return m0
}

// LabelRef is a reference to a Label, either an id or a fully-qualified name.
//
// This is used in requests.
type LabelRef struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*LabelRef_Id
	//	*LabelRef_Name_
	Value         isLabelRef_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabelRef) Reset() {
	*x = LabelRef{}
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelRef) ProtoMessage() {}

func (x *LabelRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LabelRef) GetValue() isLabelRef_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *LabelRef) GetId() string {
	if x != nil {
		if x, ok := x.Value.(*LabelRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *LabelRef) GetName() *LabelRef_Name {
	if x != nil {
		if x, ok := x.Value.(*LabelRef_Name_); ok {
			return x.Name
		}
	}
	return nil
}

func (x *LabelRef) SetId(v string) {
	x.Value = &LabelRef_Id{v}
}

func (x *LabelRef) SetName(v *LabelRef_Name) {
	if v == nil {
		x.Value = nil
		return
	}
	x.Value = &LabelRef_Name_{v}
}

func (x *LabelRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *LabelRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*LabelRef_Id)
	return ok
}

func (x *LabelRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*LabelRef_Name_)
	return ok
}

func (x *LabelRef) ClearValue() {
	x.Value = nil
}

func (x *LabelRef) ClearId() {
	if _, ok := x.Value.(*LabelRef_Id); ok {
		x.Value = nil
	}
}

func (x *LabelRef) ClearName() {
	if _, ok := x.Value.(*LabelRef_Name_); ok {
		x.Value = nil
	}
}

const LabelRef_Value_not_set_case case_LabelRef_Value = 0
const LabelRef_Id_case case_LabelRef_Value = 1
const LabelRef_Name_case case_LabelRef_Value = 2

func (x *LabelRef) WhichValue() case_LabelRef_Value {
	if x == nil {
		return LabelRef_Value_not_set_case
	}
	switch x.Value.(type) {
	case *LabelRef_Id:
		return LabelRef_Id_case
	case *LabelRef_Name_:
		return LabelRef_Name_case
	default:
		return LabelRef_Value_not_set_case
	}
}

type LabelRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Value:
	// The id of the Label.
	Id *string
	// The fully-qualified name of the Label.
	Name *LabelRef_Name
	// -- end of Value
}

func (b0 LabelRef_builder) Build() *LabelRef {
	m0 := &LabelRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.Value = &LabelRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.Value = &LabelRef_Name_{b.Name}
	}
	return m0
}

type case_LabelRef_Value protoreflect.FieldNumber

func (x case_LabelRef_Value) String() string {
	md := file_buf_registry_plugin_v1beta1_label_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isLabelRef_Value interface {
	isLabelRef_Value()
}

type LabelRef_Id struct {
	// The id of the Label.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type LabelRef_Name_ struct {
	// The fully-qualified name of the Label.
	Name *LabelRef_Name `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*LabelRef_Id) isLabelRef_Value() {}

func (*LabelRef_Name_) isLabelRef_Value() {}

// A reference to a Label scoped to a Plugin, either an id or a name.
//
// This is used in requests.
type ScopedLabelRef struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*ScopedLabelRef_Id
	//	*ScopedLabelRef_Name
	Value         isScopedLabelRef_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScopedLabelRef) Reset() {
	*x = ScopedLabelRef{}
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScopedLabelRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScopedLabelRef) ProtoMessage() {}

func (x *ScopedLabelRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ScopedLabelRef) GetValue() isScopedLabelRef_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ScopedLabelRef) GetId() string {
	if x != nil {
		if x, ok := x.Value.(*ScopedLabelRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *ScopedLabelRef) GetName() string {
	if x != nil {
		if x, ok := x.Value.(*ScopedLabelRef_Name); ok {
			return x.Name
		}
	}
	return ""
}

func (x *ScopedLabelRef) SetId(v string) {
	x.Value = &ScopedLabelRef_Id{v}
}

func (x *ScopedLabelRef) SetName(v string) {
	x.Value = &ScopedLabelRef_Name{v}
}

func (x *ScopedLabelRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *ScopedLabelRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*ScopedLabelRef_Id)
	return ok
}

func (x *ScopedLabelRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*ScopedLabelRef_Name)
	return ok
}

func (x *ScopedLabelRef) ClearValue() {
	x.Value = nil
}

func (x *ScopedLabelRef) ClearId() {
	if _, ok := x.Value.(*ScopedLabelRef_Id); ok {
		x.Value = nil
	}
}

func (x *ScopedLabelRef) ClearName() {
	if _, ok := x.Value.(*ScopedLabelRef_Name); ok {
		x.Value = nil
	}
}

const ScopedLabelRef_Value_not_set_case case_ScopedLabelRef_Value = 0
const ScopedLabelRef_Id_case case_ScopedLabelRef_Value = 1
const ScopedLabelRef_Name_case case_ScopedLabelRef_Value = 2

func (x *ScopedLabelRef) WhichValue() case_ScopedLabelRef_Value {
	if x == nil {
		return ScopedLabelRef_Value_not_set_case
	}
	switch x.Value.(type) {
	case *ScopedLabelRef_Id:
		return ScopedLabelRef_Id_case
	case *ScopedLabelRef_Name:
		return ScopedLabelRef_Name_case
	default:
		return ScopedLabelRef_Value_not_set_case
	}
}

type ScopedLabelRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Value:
	// The id of the Label.
	Id *string
	// The name of the Label.
	Name *string
	// -- end of Value
}

func (b0 ScopedLabelRef_builder) Build() *ScopedLabelRef {
	m0 := &ScopedLabelRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.Value = &ScopedLabelRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.Value = &ScopedLabelRef_Name{*b.Name}
	}
	return m0
}

type case_ScopedLabelRef_Value protoreflect.FieldNumber

func (x case_ScopedLabelRef_Value) String() string {
	md := file_buf_registry_plugin_v1beta1_label_proto_msgTypes[2].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isScopedLabelRef_Value interface {
	isScopedLabelRef_Value()
}

type ScopedLabelRef_Id struct {
	// The id of the Label.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type ScopedLabelRef_Name struct {
	// The name of the Label.
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*ScopedLabelRef_Id) isScopedLabelRef_Value() {}

func (*ScopedLabelRef_Name) isScopedLabelRef_Value() {}

// The fully-qualified name of a Label within a BSR instance.
//
// A Name uniquely identifies a Label. This is used for requests when a caller only has the label
// name and not the ID.
type LabelRef_Name struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The name of the owner of the Plugin that contains the Label, an Organization.
	Owner string `protobuf:"bytes,1,opt,name=owner,proto3" json:"owner,omitempty"`
	// The name of the Plugin that contains the Label.
	Plugin string `protobuf:"bytes,2,opt,name=plugin,proto3" json:"plugin,omitempty"`
	// The Label name.
	Label         string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabelRef_Name) Reset() {
	*x = LabelRef_Name{}
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelRef_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelRef_Name) ProtoMessage() {}

func (x *LabelRef_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_label_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LabelRef_Name) GetOwner() string {
	if x != nil {
		return x.Owner
	}
	return ""
}

func (x *LabelRef_Name) GetPlugin() string {
	if x != nil {
		return x.Plugin
	}
	return ""
}

func (x *LabelRef_Name) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *LabelRef_Name) SetOwner(v string) {
	x.Owner = v
}

func (x *LabelRef_Name) SetPlugin(v string) {
	x.Plugin = v
}

func (x *LabelRef_Name) SetLabel(v string) {
	x.Label = v
}

type LabelRef_Name_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the owner of the Plugin that contains the Label, an Organization.
	Owner string
	// The name of the Plugin that contains the Label.
	Plugin string
	// The Label name.
	Label string
}

func (b0 LabelRef_Name_builder) Build() *LabelRef_Name {
	m0 := &LabelRef_Name{}
	b, x := &b0, m0
	_, _ = b, x
	x.Owner = b.Owner
	x.Plugin = b.Plugin
	x.Label = b.Label
	return m0
}

var File_buf_registry_plugin_v1beta1_label_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_label_proto_rawDesc = "" +
	"\n" +
	"'buf/registry/plugin/v1beta1/label.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xcc\x03\n" +
	"\x05Label\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12C\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"updateTime\x12=\n" +
	"\farchive_time\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampR\varchiveTime\x12\x1f\n" +
	"\x04name\x18\x05 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x18\xfa\x01R\x04name\x12&\n" +
	"\bowner_id\x18\x06 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\aownerId\x12(\n" +
	"\tplugin_id\x18\a \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\bpluginId\x12(\n" +
	"\tcommit_id\x18\b \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\bcommitId\x128\n" +
	"\x12updated_by_user_id\x18\t \x01(\tB\v\xbaH\b\xd8\x01\x01r\x03\x88\x02\x01R\x0fupdatedByUserId:\x06\xea\xc5+\x02\x10\x01\"\xf0\x01\n" +
	"\bLabelRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12@\n" +
	"\x04name\x18\x02 \x01(\v2*.buf.registry.plugin.v1beta1.LabelRef.NameH\x00R\x04name\x1an\n" +
	"\x04Name\x12 \n" +
	"\x05owner\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x18 R\x05owner\x12!\n" +
	"\x06plugin\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x06plugin\x12!\n" +
	"\x05label\x18\x03 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x18\xfa\x01R\x05label:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01\"Z\n" +
	"\x0eScopedLabelRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12\x14\n" +
	"\x04name\x18\x02 \x01(\tH\x00R\x04name:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_label_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_buf_registry_plugin_v1beta1_label_proto_goTypes = []any{
	(*Label)(nil),                 // 0: buf.registry.plugin.v1beta1.Label
	(*LabelRef)(nil),              // 1: buf.registry.plugin.v1beta1.LabelRef
	(*ScopedLabelRef)(nil),        // 2: buf.registry.plugin.v1beta1.ScopedLabelRef
	(*LabelRef_Name)(nil),         // 3: buf.registry.plugin.v1beta1.LabelRef.Name
	(*timestamppb.Timestamp)(nil), // 4: google.protobuf.Timestamp
}
var file_buf_registry_plugin_v1beta1_label_proto_depIdxs = []int32{
	4, // 0: buf.registry.plugin.v1beta1.Label.create_time:type_name -> google.protobuf.Timestamp
	4, // 1: buf.registry.plugin.v1beta1.Label.update_time:type_name -> google.protobuf.Timestamp
	4, // 2: buf.registry.plugin.v1beta1.Label.archive_time:type_name -> google.protobuf.Timestamp
	3, // 3: buf.registry.plugin.v1beta1.LabelRef.name:type_name -> buf.registry.plugin.v1beta1.LabelRef.Name
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_label_proto_init() }
func file_buf_registry_plugin_v1beta1_label_proto_init() {
	if File_buf_registry_plugin_v1beta1_label_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_label_proto_msgTypes[1].OneofWrappers = []any{
		(*LabelRef_Id)(nil),
		(*LabelRef_Name_)(nil),
	}
	file_buf_registry_plugin_v1beta1_label_proto_msgTypes[2].OneofWrappers = []any{
		(*ScopedLabelRef_Id)(nil),
		(*ScopedLabelRef_Name)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_label_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_label_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_label_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_label_proto_depIdxs,
		MessageInfos:      file_buf_registry_plugin_v1beta1_label_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_label_proto = out.File
	file_buf_registry_plugin_v1beta1_label_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_label_proto_depIdxs = nil
}
