// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/owner/v1/owner.proto

//go:build !protoopaque

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A User or Organization.
type Owner struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*Owner_User
	//	*Owner_Organization
	Value         isOwner_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Owner) Reset() {
	*x = Owner{}
	mi := &file_buf_registry_owner_v1_owner_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Owner) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Owner) ProtoMessage() {}

func (x *Owner) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_owner_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Owner) GetValue() isOwner_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Owner) GetUser() *User {
	if x != nil {
		if x, ok := x.Value.(*Owner_User); ok {
			return x.User
		}
	}
	return nil
}

func (x *Owner) GetOrganization() *Organization {
	if x != nil {
		if x, ok := x.Value.(*Owner_Organization); ok {
			return x.Organization
		}
	}
	return nil
}

func (x *Owner) SetUser(v *User) {
	if v == nil {
		x.Value = nil
		return
	}
	x.Value = &Owner_User{v}
}

func (x *Owner) SetOrganization(v *Organization) {
	if v == nil {
		x.Value = nil
		return
	}
	x.Value = &Owner_Organization{v}
}

func (x *Owner) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *Owner) HasUser() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*Owner_User)
	return ok
}

func (x *Owner) HasOrganization() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*Owner_Organization)
	return ok
}

func (x *Owner) ClearValue() {
	x.Value = nil
}

func (x *Owner) ClearUser() {
	if _, ok := x.Value.(*Owner_User); ok {
		x.Value = nil
	}
}

func (x *Owner) ClearOrganization() {
	if _, ok := x.Value.(*Owner_Organization); ok {
		x.Value = nil
	}
}

const Owner_Value_not_set_case case_Owner_Value = 0
const Owner_User_case case_Owner_Value = 1
const Owner_Organization_case case_Owner_Value = 2

func (x *Owner) WhichValue() case_Owner_Value {
	if x == nil {
		return Owner_Value_not_set_case
	}
	switch x.Value.(type) {
	case *Owner_User:
		return Owner_User_case
	case *Owner_Organization:
		return Owner_Organization_case
	default:
		return Owner_Value_not_set_case
	}
}

type Owner_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Value:
	// The User.
	User *User
	// The Organization.
	Organization *Organization
	// -- end of Value
}

func (b0 Owner_builder) Build() *Owner {
	m0 := &Owner{}
	b, x := &b0, m0
	_, _ = b, x
	if b.User != nil {
		x.Value = &Owner_User{b.User}
	}
	if b.Organization != nil {
		x.Value = &Owner_Organization{b.Organization}
	}
	return m0
}

type case_Owner_Value protoreflect.FieldNumber

func (x case_Owner_Value) String() string {
	md := file_buf_registry_owner_v1_owner_proto_msgTypes[0].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isOwner_Value interface {
	isOwner_Value()
}

type Owner_User struct {
	// The User.
	User *User `protobuf:"bytes,1,opt,name=user,proto3,oneof"`
}

type Owner_Organization struct {
	// The Organization.
	Organization *Organization `protobuf:"bytes,2,opt,name=organization,proto3,oneof"`
}

func (*Owner_User) isOwner_Value() {}

func (*Owner_Organization) isOwner_Value() {}

// OwnerRef is a reference to a User or Organization, either an id or a name.
//
// This is used in requests.
type OwnerRef struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Value:
	//
	//	*OwnerRef_Id
	//	*OwnerRef_Name
	Value         isOwnerRef_Value `protobuf_oneof:"value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OwnerRef) Reset() {
	*x = OwnerRef{}
	mi := &file_buf_registry_owner_v1_owner_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OwnerRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OwnerRef) ProtoMessage() {}

func (x *OwnerRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_owner_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OwnerRef) GetValue() isOwnerRef_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *OwnerRef) GetId() string {
	if x != nil {
		if x, ok := x.Value.(*OwnerRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *OwnerRef) GetName() string {
	if x != nil {
		if x, ok := x.Value.(*OwnerRef_Name); ok {
			return x.Name
		}
	}
	return ""
}

func (x *OwnerRef) SetId(v string) {
	x.Value = &OwnerRef_Id{v}
}

func (x *OwnerRef) SetName(v string) {
	x.Value = &OwnerRef_Name{v}
}

func (x *OwnerRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *OwnerRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*OwnerRef_Id)
	return ok
}

func (x *OwnerRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.Value.(*OwnerRef_Name)
	return ok
}

func (x *OwnerRef) ClearValue() {
	x.Value = nil
}

func (x *OwnerRef) ClearId() {
	if _, ok := x.Value.(*OwnerRef_Id); ok {
		x.Value = nil
	}
}

func (x *OwnerRef) ClearName() {
	if _, ok := x.Value.(*OwnerRef_Name); ok {
		x.Value = nil
	}
}

const OwnerRef_Value_not_set_case case_OwnerRef_Value = 0
const OwnerRef_Id_case case_OwnerRef_Value = 1
const OwnerRef_Name_case case_OwnerRef_Value = 2

func (x *OwnerRef) WhichValue() case_OwnerRef_Value {
	if x == nil {
		return OwnerRef_Value_not_set_case
	}
	switch x.Value.(type) {
	case *OwnerRef_Id:
		return OwnerRef_Id_case
	case *OwnerRef_Name:
		return OwnerRef_Name_case
	default:
		return OwnerRef_Value_not_set_case
	}
}

type OwnerRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Value:
	// The id of the User or Organization.
	Id *string
	// The name of the User or Organization.
	Name *string
	// -- end of Value
}

func (b0 OwnerRef_builder) Build() *OwnerRef {
	m0 := &OwnerRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.Value = &OwnerRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.Value = &OwnerRef_Name{*b.Name}
	}
	return m0
}

type case_OwnerRef_Value protoreflect.FieldNumber

func (x case_OwnerRef_Value) String() string {
	md := file_buf_registry_owner_v1_owner_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isOwnerRef_Value interface {
	isOwnerRef_Value()
}

type OwnerRef_Id struct {
	// The id of the User or Organization.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type OwnerRef_Name struct {
	// The name of the User or Organization.
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*OwnerRef_Id) isOwnerRef_Value() {}

func (*OwnerRef_Name) isOwnerRef_Value() {}

var File_buf_registry_owner_v1_owner_proto protoreflect.FileDescriptor

const file_buf_registry_owner_v1_owner_proto_rawDesc = "" +
	"\n" +
	"!buf/registry/owner/v1/owner.proto\x12\x15buf.registry.owner.v1\x1a(buf/registry/owner/v1/organization.proto\x1a buf/registry/owner/v1/user.proto\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\"\x9d\x01\n" +
	"\x05Owner\x121\n" +
	"\x04user\x18\x01 \x01(\v2\x1b.buf.registry.owner.v1.UserH\x00R\x04user\x12I\n" +
	"\forganization\x18\x02 \x01(\v2#.buf.registry.owner.v1.OrganizationH\x00R\forganization:\x06\xea\xc5+\x02\x10\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01\"z\n" +
	"\bOwnerRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12:\n" +
	"\x04name\x18\x02 \x01(\tB$\xbaH!r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$H\x00R\x04name:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01BUZSbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1;ownerv1b\x06proto3"

var file_buf_registry_owner_v1_owner_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_buf_registry_owner_v1_owner_proto_goTypes = []any{
	(*Owner)(nil),        // 0: buf.registry.owner.v1.Owner
	(*OwnerRef)(nil),     // 1: buf.registry.owner.v1.OwnerRef
	(*User)(nil),         // 2: buf.registry.owner.v1.User
	(*Organization)(nil), // 3: buf.registry.owner.v1.Organization
}
var file_buf_registry_owner_v1_owner_proto_depIdxs = []int32{
	2, // 0: buf.registry.owner.v1.Owner.user:type_name -> buf.registry.owner.v1.User
	3, // 1: buf.registry.owner.v1.Owner.organization:type_name -> buf.registry.owner.v1.Organization
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_owner_proto_init() }
func file_buf_registry_owner_v1_owner_proto_init() {
	if File_buf_registry_owner_v1_owner_proto != nil {
		return
	}
	file_buf_registry_owner_v1_organization_proto_init()
	file_buf_registry_owner_v1_user_proto_init()
	file_buf_registry_owner_v1_owner_proto_msgTypes[0].OneofWrappers = []any{
		(*Owner_User)(nil),
		(*Owner_Organization)(nil),
	}
	file_buf_registry_owner_v1_owner_proto_msgTypes[1].OneofWrappers = []any{
		(*OwnerRef_Id)(nil),
		(*OwnerRef_Name)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_owner_v1_owner_proto_rawDesc), len(file_buf_registry_owner_v1_owner_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_owner_v1_owner_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_owner_proto_depIdxs,
		MessageInfos:      file_buf_registry_owner_v1_owner_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_owner_proto = out.File
	file_buf_registry_owner_v1_owner_proto_goTypes = nil
	file_buf_registry_owner_v1_owner_proto_depIdxs = nil
}
