// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/module/v1beta1/graph_service.proto

//go:build !protoopaque

package modulev1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetGraphRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The references to resolve to Commits to include in the graph.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Once the resource is resolved, the following Commit is included:
	//   - If a Module is referenced, the Commit of the default Label is included.
	//   - If a Label is referenced, the Commit of this Label is included.
	//   - If a Commit is referenced, the Commit is included.
	//
	// The specified ResourceRefs must reference unique Modules, that is no two ResourceRefs
	// may resolve to the same Module.
	ResourceRefs []*GetGraphRequest_ResourceRef `protobuf:"bytes,1,rep,name=resource_refs,json=resourceRefs,proto3" json:"resource_refs,omitempty"`
	// The DigestType to return for Commit nodes.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used.
	DigestType    DigestType `protobuf:"varint,2,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.module.v1beta1.DigestType" json:"digest_type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGraphRequest) Reset() {
	*x = GetGraphRequest{}
	mi := &file_buf_registry_module_v1beta1_graph_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphRequest) ProtoMessage() {}

func (x *GetGraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_graph_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGraphRequest) GetResourceRefs() []*GetGraphRequest_ResourceRef {
	if x != nil {
		return x.ResourceRefs
	}
	return nil
}

func (x *GetGraphRequest) GetDigestType() DigestType {
	if x != nil {
		return x.DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *GetGraphRequest) SetResourceRefs(v []*GetGraphRequest_ResourceRef) {
	x.ResourceRefs = v
}

func (x *GetGraphRequest) SetDigestType(v DigestType) {
	x.DigestType = v
}

type GetGraphRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The references to resolve to Commits to include in the graph.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Once the resource is resolved, the following Commit is included:
	//   - If a Module is referenced, the Commit of the default Label is included.
	//   - If a Label is referenced, the Commit of this Label is included.
	//   - If a Commit is referenced, the Commit is included.
	//
	// The specified ResourceRefs must reference unique Modules, that is no two ResourceRefs
	// may resolve to the same Module.
	ResourceRefs []*GetGraphRequest_ResourceRef
	// The DigestType to return for Commit nodes.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used.
	DigestType DigestType
}

func (b0 GetGraphRequest_builder) Build() *GetGraphRequest {
	m0 := &GetGraphRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.ResourceRefs = b.ResourceRefs
	x.DigestType = b.DigestType
	return m0
}

// See the package documentation for more details. You should likely use buf.registry.module.v1beta1
// and not this package.
type GetGraphResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Graph calculated for the Commits.
	Graph         *Graph `protobuf:"bytes,1,opt,name=graph,proto3" json:"graph,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGraphResponse) Reset() {
	*x = GetGraphResponse{}
	mi := &file_buf_registry_module_v1beta1_graph_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGraphResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphResponse) ProtoMessage() {}

func (x *GetGraphResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_graph_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGraphResponse) GetGraph() *Graph {
	if x != nil {
		return x.Graph
	}
	return nil
}

func (x *GetGraphResponse) SetGraph(v *Graph) {
	x.Graph = v
}

func (x *GetGraphResponse) HasGraph() bool {
	if x == nil {
		return false
	}
	return x.Graph != nil
}

func (x *GetGraphResponse) ClearGraph() {
	x.Graph = nil
}

type GetGraphResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Graph calculated for the Commits.
	Graph *Graph
}

func (b0 GetGraphResponse_builder) Build() *GetGraphResponse {
	m0 := &GetGraphResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Graph = b.Graph
	return m0
}

// A ResourceRef to reference a Commit to include in the Graph.
//
// This wraps the top-level ResourceRef.
type GetGraphRequest_ResourceRef struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The top-level ResourceRef.
	ResourceRef *ResourceRef `protobuf:"bytes,1,opt,name=resource_ref,json=resourceRef,proto3" json:"resource_ref,omitempty"`
	// The registry hostname of the Resourceref.
	Registry      string `protobuf:"bytes,2,opt,name=registry,proto3" json:"registry,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetGraphRequest_ResourceRef) Reset() {
	*x = GetGraphRequest_ResourceRef{}
	mi := &file_buf_registry_module_v1beta1_graph_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGraphRequest_ResourceRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGraphRequest_ResourceRef) ProtoMessage() {}

func (x *GetGraphRequest_ResourceRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_graph_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetGraphRequest_ResourceRef) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.ResourceRef
	}
	return nil
}

func (x *GetGraphRequest_ResourceRef) GetRegistry() string {
	if x != nil {
		return x.Registry
	}
	return ""
}

func (x *GetGraphRequest_ResourceRef) SetResourceRef(v *ResourceRef) {
	x.ResourceRef = v
}

func (x *GetGraphRequest_ResourceRef) SetRegistry(v string) {
	x.Registry = v
}

func (x *GetGraphRequest_ResourceRef) HasResourceRef() bool {
	if x == nil {
		return false
	}
	return x.ResourceRef != nil
}

func (x *GetGraphRequest_ResourceRef) ClearResourceRef() {
	x.ResourceRef = nil
}

type GetGraphRequest_ResourceRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The top-level ResourceRef.
	ResourceRef *ResourceRef
	// The registry hostname of the Resourceref.
	Registry string
}

func (b0 GetGraphRequest_ResourceRef_builder) Build() *GetGraphRequest_ResourceRef {
	m0 := &GetGraphRequest_ResourceRef{}
	b, x := &b0, m0
	_, _ = b, x
	x.ResourceRef = b.ResourceRef
	x.Registry = b.Registry
	return m0
}

var File_buf_registry_module_v1beta1_graph_service_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1beta1_graph_service_proto_rawDesc = "" +
	"\n" +
	"/buf/registry/module/v1beta1/graph_service.proto\x12\x1bbuf.registry.module.v1beta1\x1a(buf/registry/module/v1beta1/digest.proto\x1a'buf/registry/module/v1beta1/graph.proto\x1a*buf/registry/module/v1beta1/resource.proto\x1a\x1bbuf/validate/validate.proto\"\xda\x02\n" +
	"\x0fGetGraphRequest\x12j\n" +
	"\rresource_refs\x18\x01 \x03(\v28.buf.registry.module.v1beta1.GetGraphRequest.ResourceRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\fresourceRefs\x12R\n" +
	"\vdigest_type\x18\x02 \x01(\x0e2'.buf.registry.module.v1beta1.DigestTypeB\b\xbaH\x05\x82\x01\x02\x10\x01R\n" +
	"digestType\x1a\x86\x01\n" +
	"\vResourceRef\x12S\n" +
	"\fresource_ref\x18\x01 \x01(\v2(.buf.registry.module.v1beta1.ResourceRefB\x06\xbaH\x03\xc8\x01\x01R\vresourceRef\x12\"\n" +
	"\bregistry\x18\x02 \x01(\tB\x06\xbaH\x03\xc8\x01\x01R\bregistry\"T\n" +
	"\x10GetGraphResponse\x12@\n" +
	"\x05graph\x18\x01 \x01(\v2\".buf.registry.module.v1beta1.GraphB\x06\xbaH\x03\xc8\x01\x01R\x05graph2|\n" +
	"\fGraphService\x12l\n" +
	"\bGetGraph\x12,.buf.registry.module.v1beta1.GetGraphRequest\x1a-.buf.registry.module.v1beta1.GetGraphResponse\"\x03\x90\x02\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1beta1;modulev1beta1b\x06proto3"

var file_buf_registry_module_v1beta1_graph_service_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_module_v1beta1_graph_service_proto_goTypes = []any{
	(*GetGraphRequest)(nil),             // 0: buf.registry.module.v1beta1.GetGraphRequest
	(*GetGraphResponse)(nil),            // 1: buf.registry.module.v1beta1.GetGraphResponse
	(*GetGraphRequest_ResourceRef)(nil), // 2: buf.registry.module.v1beta1.GetGraphRequest.ResourceRef
	(DigestType)(0),                     // 3: buf.registry.module.v1beta1.DigestType
	(*Graph)(nil),                       // 4: buf.registry.module.v1beta1.Graph
	(*ResourceRef)(nil),                 // 5: buf.registry.module.v1beta1.ResourceRef
}
var file_buf_registry_module_v1beta1_graph_service_proto_depIdxs = []int32{
	2, // 0: buf.registry.module.v1beta1.GetGraphRequest.resource_refs:type_name -> buf.registry.module.v1beta1.GetGraphRequest.ResourceRef
	3, // 1: buf.registry.module.v1beta1.GetGraphRequest.digest_type:type_name -> buf.registry.module.v1beta1.DigestType
	4, // 2: buf.registry.module.v1beta1.GetGraphResponse.graph:type_name -> buf.registry.module.v1beta1.Graph
	5, // 3: buf.registry.module.v1beta1.GetGraphRequest.ResourceRef.resource_ref:type_name -> buf.registry.module.v1beta1.ResourceRef
	0, // 4: buf.registry.module.v1beta1.GraphService.GetGraph:input_type -> buf.registry.module.v1beta1.GetGraphRequest
	1, // 5: buf.registry.module.v1beta1.GraphService.GetGraph:output_type -> buf.registry.module.v1beta1.GetGraphResponse
	5, // [5:6] is the sub-list for method output_type
	4, // [4:5] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1beta1_graph_service_proto_init() }
func file_buf_registry_module_v1beta1_graph_service_proto_init() {
	if File_buf_registry_module_v1beta1_graph_service_proto != nil {
		return
	}
	file_buf_registry_module_v1beta1_digest_proto_init()
	file_buf_registry_module_v1beta1_graph_proto_init()
	file_buf_registry_module_v1beta1_resource_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1beta1_graph_service_proto_rawDesc), len(file_buf_registry_module_v1beta1_graph_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1beta1_graph_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1beta1_graph_service_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1beta1_graph_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1beta1_graph_service_proto = out.File
	file_buf_registry_module_v1beta1_graph_service_proto_goTypes = nil
	file_buf_registry_module_v1beta1_graph_service_proto_depIdxs = nil
}
