// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/module/v1beta1/file.proto

//go:build protoopaque

package modulev1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A specific file type.
type FileType int32

const (
	FileType_FILE_TYPE_UNSPECIFIED FileType = 0
	// A .proto file.
	FileType_FILE_TYPE_PROTO FileType = 1
	// A documentation file.
	//
	// Documentation files are always named README.md, README.markdown, or buf.md.
	FileType_FILE_TYPE_DOC FileType = 2
	// A license file.
	//
	// License files are always named LICENSE.
	FileType_FILE_TYPE_LICENSE FileType = 3
)

// Enum value maps for FileType.
var (
	FileType_name = map[int32]string{
		0: "FILE_TYPE_UNSPECIFIED",
		1: "FILE_TYPE_PROTO",
		2: "FILE_TYPE_DOC",
		3: "FILE_TYPE_LICENSE",
	}
	FileType_value = map[string]int32{
		"FILE_TYPE_UNSPECIFIED": 0,
		"FILE_TYPE_PROTO":       1,
		"FILE_TYPE_DOC":         2,
		"FILE_TYPE_LICENSE":     3,
	}
)

func (x FileType) Enum() *FileType {
	p := new(FileType)
	*p = x
	return p
}

func (x FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1beta1_file_proto_enumTypes[0].Descriptor()
}

func (FileType) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1beta1_file_proto_enumTypes[0]
}

func (x FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// A file that can be read or written to from disk.
//
// A File includes a path and associated content.
// Files are purposefully simple, and do not include attributes such as permissions.
type File struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Path    string                 `protobuf:"bytes,1,opt,name=path,proto3"`
	xxx_hidden_Content []byte                 `protobuf:"bytes,2,opt,name=content,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *File) Reset() {
	*x = File{}
	mi := &file_buf_registry_module_v1beta1_file_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*File) ProtoMessage() {}

func (x *File) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1beta1_file_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *File) GetPath() string {
	if x != nil {
		return x.xxx_hidden_Path
	}
	return ""
}

func (x *File) GetContent() []byte {
	if x != nil {
		return x.xxx_hidden_Content
	}
	return nil
}

func (x *File) SetPath(v string) {
	x.xxx_hidden_Path = v
}

func (x *File) SetContent(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Content = v
}

type File_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The path of the File.
	//
	// The path must be relative, and cannot contain any "." or ".." components.
	// The separator "/" must be used.
	Path string
	// The content of the File.
	//
	// May be empty.
	Content []byte
}

func (b0 File_builder) Build() *File {
	m0 := &File{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Path = b.Path
	x.xxx_hidden_Content = b.Content
	return m0
}

var File_buf_registry_module_v1beta1_file_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1beta1_file_proto_rawDesc = "" +
	"\n" +
	"&buf/registry/module/v1beta1/file.proto\x12\x1bbuf.registry.module.v1beta1\x1a\x1bbuf/validate/validate.proto\"\x8b\x01\n" +
	"\x04File\x12i\n" +
	"\x04path\x18\x01 \x01(\tBU\xbaHR\xc8\x01\x01rM\x18\x80 2D^([^/.][^/]?|[^/][^/.]|[^/]{3,})(/([^/.][^/]?|[^/][^/.]|[^/]{3,}))*$\xba\x01\x01\\R\x04path\x12\x18\n" +
	"\acontent\x18\x02 \x01(\fR\acontent*d\n" +
	"\bFileType\x12\x19\n" +
	"\x15FILE_TYPE_UNSPECIFIED\x10\x00\x12\x13\n" +
	"\x0fFILE_TYPE_PROTO\x10\x01\x12\x11\n" +
	"\rFILE_TYPE_DOC\x10\x02\x12\x15\n" +
	"\x11FILE_TYPE_LICENSE\x10\x03BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1beta1;modulev1beta1b\x06proto3"

var file_buf_registry_module_v1beta1_file_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_module_v1beta1_file_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_registry_module_v1beta1_file_proto_goTypes = []any{
	(FileType)(0), // 0: buf.registry.module.v1beta1.FileType
	(*File)(nil),  // 1: buf.registry.module.v1beta1.File
}
var file_buf_registry_module_v1beta1_file_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1beta1_file_proto_init() }
func file_buf_registry_module_v1beta1_file_proto_init() {
	if File_buf_registry_module_v1beta1_file_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1beta1_file_proto_rawDesc), len(file_buf_registry_module_v1beta1_file_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_module_v1beta1_file_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1beta1_file_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1beta1_file_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1beta1_file_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1beta1_file_proto = out.File
	file_buf_registry_module_v1beta1_file_proto_goTypes = nil
	file_buf_registry_module_v1beta1_file_proto_depIdxs = nil
}
