// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/registry/module/v1/file_descriptor_set_service.proto

//go:build !protoopaque

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetFileDescriptorSetRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The reference to get the FileDescriptorSet for.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Once the resource is resolved, the following content is returned:
	//   - If a Module is referenced, the FileDescriptorSet for the Commit of the default Label is returned.
	//   - If a Label is referenced, the FileDescriptorSet for the Commit of this Label is returned.
	//   - If a Commit is referenced, the FileDescriptorSet for this Commit is returned.
	ResourceRef *ResourceRef `protobuf:"bytes,1,opt,name=resource_ref,json=resourceRef,proto3" json:"resource_ref,omitempty"`
	// Exclude imports from the returned FileDescriptorSet.
	//
	// A file is an import if:
	//
	//   - It comes from a dependency of the Module specified via the ResourceRef used in the request.
	//     For example, if the ResourceRef specifies "buf.build/foo/bar", which depends on
	//     "buf.build/foo/baz", all files from "buf.build/foo/baz" will be imports.
	//   - It is a Well-Known Type, and the Well-Known Type was not part of the Module specified
	//     via the ResourceRef used in the request. Well-Known Types are special in the Protobuf ecosystem,
	//     and can be imported without being contained in a specified module.
	//   - It contains types that are referenced by types specified in the request. For example,
	//     if the request specified symbol "foo.v1.Foo" contained within "foo.proto", which has a message
	//     field of type "baz.v1.Baz", which is contained within "baz.proto", then the file "baz.proto"
	//     will be marked as an import, regardless of which Module it derived from. If the types field
	//     is not specified on the request, this situation will never occur.
	//
	// Note that if imports are excluded, the returned FileDescriptorSet may not (and likely will not)
	// be self-contained. If imports are included, all types referenced within the FileDescriptorSet
	// are contained within the returned FileDescriptorSet.
	ExcludeImports bool `protobuf:"varint,2,opt,name=exclude_imports,json=excludeImports,proto3" json:"exclude_imports,omitempty"`
	// Include SourceCodeInfo in the returned FileDescriptorProtos.
	//
	// SourceCodeInfo is optional additional information that is not required to describe a set
	// of Protobuf APIs.
	IncludeSourceCodeInfo bool `protobuf:"varint,3,opt,name=include_source_code_info,json=includeSourceCodeInfo,proto3" json:"include_source_code_info,omitempty"`
	// Include source-retention options in the returned FileDescriptorProtos.
	//
	// With the new Editions work, options are either runtime-retention or source-retention.
	// Setting this option will include the latter.
	IncludeSourceRetentionOptions bool `protobuf:"varint,4,opt,name=include_source_retention_options,json=includeSourceRetentionOptions,proto3" json:"include_source_retention_options,omitempty"`
	// Only include the specified types (and types that they reference, if exclude_imports is not set).
	//
	// A type is a package, message, enum, service, method, or extension.
	//
	// Types are referenced by their fully-qualified name. For example, if "Foo" is a message within
	// the package "foo.v1", the fully-qualified name is "foo.v1.Foo". Fully-qualified names should
	// not start with a period, that is specify "foo.v1.Foo", not ".foo.v1.Foo".
	//
	// If no types are provided, all types are returned.
	IncludeTypes []string `protobuf:"bytes,5,rep,name=include_types,json=includeTypes,proto3" json:"include_types,omitempty"`
	// Exclude the specified types (and types that they reference if they are the only the
	// only references to those types, if exclude_imports is not set).
	//
	// A type is a package, message, enum, service, method, or extension.
	//
	// Types are referenced by their fully-qualified name. For example, if "Foo" is a message within
	// the package "foo.v1", the fully-qualified name is "foo.v1.Foo". Fully-qualfied names should
	// not start with a period, that is specify "foo.v1.Foo", not ".foo.v1.Foo".
	ExcludeTypes  []string `protobuf:"bytes,6,rep,name=exclude_types,json=excludeTypes,proto3" json:"exclude_types,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFileDescriptorSetRequest) Reset() {
	*x = GetFileDescriptorSetRequest{}
	mi := &file_buf_registry_module_v1_file_descriptor_set_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFileDescriptorSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileDescriptorSetRequest) ProtoMessage() {}

func (x *GetFileDescriptorSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_file_descriptor_set_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetFileDescriptorSetRequest) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.ResourceRef
	}
	return nil
}

func (x *GetFileDescriptorSetRequest) GetExcludeImports() bool {
	if x != nil {
		return x.ExcludeImports
	}
	return false
}

func (x *GetFileDescriptorSetRequest) GetIncludeSourceCodeInfo() bool {
	if x != nil {
		return x.IncludeSourceCodeInfo
	}
	return false
}

func (x *GetFileDescriptorSetRequest) GetIncludeSourceRetentionOptions() bool {
	if x != nil {
		return x.IncludeSourceRetentionOptions
	}
	return false
}

func (x *GetFileDescriptorSetRequest) GetIncludeTypes() []string {
	if x != nil {
		return x.IncludeTypes
	}
	return nil
}

func (x *GetFileDescriptorSetRequest) GetExcludeTypes() []string {
	if x != nil {
		return x.ExcludeTypes
	}
	return nil
}

func (x *GetFileDescriptorSetRequest) SetResourceRef(v *ResourceRef) {
	x.ResourceRef = v
}

func (x *GetFileDescriptorSetRequest) SetExcludeImports(v bool) {
	x.ExcludeImports = v
}

func (x *GetFileDescriptorSetRequest) SetIncludeSourceCodeInfo(v bool) {
	x.IncludeSourceCodeInfo = v
}

func (x *GetFileDescriptorSetRequest) SetIncludeSourceRetentionOptions(v bool) {
	x.IncludeSourceRetentionOptions = v
}

func (x *GetFileDescriptorSetRequest) SetIncludeTypes(v []string) {
	x.IncludeTypes = v
}

func (x *GetFileDescriptorSetRequest) SetExcludeTypes(v []string) {
	x.ExcludeTypes = v
}

func (x *GetFileDescriptorSetRequest) HasResourceRef() bool {
	if x == nil {
		return false
	}
	return x.ResourceRef != nil
}

func (x *GetFileDescriptorSetRequest) ClearResourceRef() {
	x.ResourceRef = nil
}

type GetFileDescriptorSetRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The reference to get the FileDescriptorSet for.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Once the resource is resolved, the following content is returned:
	//   - If a Module is referenced, the FileDescriptorSet for the Commit of the default Label is returned.
	//   - If a Label is referenced, the FileDescriptorSet for the Commit of this Label is returned.
	//   - If a Commit is referenced, the FileDescriptorSet for this Commit is returned.
	ResourceRef *ResourceRef
	// Exclude imports from the returned FileDescriptorSet.
	//
	// A file is an import if:
	//
	//   - It comes from a dependency of the Module specified via the ResourceRef used in the request.
	//     For example, if the ResourceRef specifies "buf.build/foo/bar", which depends on
	//     "buf.build/foo/baz", all files from "buf.build/foo/baz" will be imports.
	//   - It is a Well-Known Type, and the Well-Known Type was not part of the Module specified
	//     via the ResourceRef used in the request. Well-Known Types are special in the Protobuf ecosystem,
	//     and can be imported without being contained in a specified module.
	//   - It contains types that are referenced by types specified in the request. For example,
	//     if the request specified symbol "foo.v1.Foo" contained within "foo.proto", which has a message
	//     field of type "baz.v1.Baz", which is contained within "baz.proto", then the file "baz.proto"
	//     will be marked as an import, regardless of which Module it derived from. If the types field
	//     is not specified on the request, this situation will never occur.
	//
	// Note that if imports are excluded, the returned FileDescriptorSet may not (and likely will not)
	// be self-contained. If imports are included, all types referenced within the FileDescriptorSet
	// are contained within the returned FileDescriptorSet.
	ExcludeImports bool
	// Include SourceCodeInfo in the returned FileDescriptorProtos.
	//
	// SourceCodeInfo is optional additional information that is not required to describe a set
	// of Protobuf APIs.
	IncludeSourceCodeInfo bool
	// Include source-retention options in the returned FileDescriptorProtos.
	//
	// With the new Editions work, options are either runtime-retention or source-retention.
	// Setting this option will include the latter.
	IncludeSourceRetentionOptions bool
	// Only include the specified types (and types that they reference, if exclude_imports is not set).
	//
	// A type is a package, message, enum, service, method, or extension.
	//
	// Types are referenced by their fully-qualified name. For example, if "Foo" is a message within
	// the package "foo.v1", the fully-qualified name is "foo.v1.Foo". Fully-qualified names should
	// not start with a period, that is specify "foo.v1.Foo", not ".foo.v1.Foo".
	//
	// If no types are provided, all types are returned.
	IncludeTypes []string
	// Exclude the specified types (and types that they reference if they are the only the
	// only references to those types, if exclude_imports is not set).
	//
	// A type is a package, message, enum, service, method, or extension.
	//
	// Types are referenced by their fully-qualified name. For example, if "Foo" is a message within
	// the package "foo.v1", the fully-qualified name is "foo.v1.Foo". Fully-qualfied names should
	// not start with a period, that is specify "foo.v1.Foo", not ".foo.v1.Foo".
	ExcludeTypes []string
}

func (b0 GetFileDescriptorSetRequest_builder) Build() *GetFileDescriptorSetRequest {
	m0 := &GetFileDescriptorSetRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.ResourceRef = b.ResourceRef
	x.ExcludeImports = b.ExcludeImports
	x.IncludeSourceCodeInfo = b.IncludeSourceCodeInfo
	x.IncludeSourceRetentionOptions = b.IncludeSourceRetentionOptions
	x.IncludeTypes = b.IncludeTypes
	x.ExcludeTypes = b.ExcludeTypes
	return m0
}

type GetFileDescriptorSetResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The FileDescriptorSet representing the referenced Module, Label, or Commit.
	FileDescriptorSet *descriptorpb.FileDescriptorSet `protobuf:"bytes,1,opt,name=file_descriptor_set,json=fileDescriptorSet,proto3" json:"file_descriptor_set,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GetFileDescriptorSetResponse) Reset() {
	*x = GetFileDescriptorSetResponse{}
	mi := &file_buf_registry_module_v1_file_descriptor_set_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFileDescriptorSetResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFileDescriptorSetResponse) ProtoMessage() {}

func (x *GetFileDescriptorSetResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_file_descriptor_set_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetFileDescriptorSetResponse) GetFileDescriptorSet() *descriptorpb.FileDescriptorSet {
	if x != nil {
		return x.FileDescriptorSet
	}
	return nil
}

func (x *GetFileDescriptorSetResponse) SetFileDescriptorSet(v *descriptorpb.FileDescriptorSet) {
	x.FileDescriptorSet = v
}

func (x *GetFileDescriptorSetResponse) HasFileDescriptorSet() bool {
	if x == nil {
		return false
	}
	return x.FileDescriptorSet != nil
}

func (x *GetFileDescriptorSetResponse) ClearFileDescriptorSet() {
	x.FileDescriptorSet = nil
}

type GetFileDescriptorSetResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The FileDescriptorSet representing the referenced Module, Label, or Commit.
	FileDescriptorSet *descriptorpb.FileDescriptorSet
}

func (b0 GetFileDescriptorSetResponse_builder) Build() *GetFileDescriptorSetResponse {
	m0 := &GetFileDescriptorSetResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.FileDescriptorSet = b.FileDescriptorSet
	return m0
}

var File_buf_registry_module_v1_file_descriptor_set_service_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1_file_descriptor_set_service_proto_rawDesc = "" +
	"\n" +
	"8buf/registry/module/v1/file_descriptor_set_service.proto\x12\x16buf.registry.module.v1\x1a%buf/registry/module/v1/resource.proto\x1a\x1bbuf/validate/validate.proto\x1a google/protobuf/descriptor.proto\"\xbe\x04\n" +
	"\x1bGetFileDescriptorSetRequest\x12N\n" +
	"\fresource_ref\x18\x01 \x01(\v2#.buf.registry.module.v1.ResourceRefB\x06\xbaH\x03\xc8\x01\x01R\vresourceRef\x12'\n" +
	"\x0fexclude_imports\x18\x02 \x01(\bR\x0eexcludeImports\x127\n" +
	"\x18include_source_code_info\x18\x03 \x01(\bR\x15includeSourceCodeInfo\x12G\n" +
	" include_source_retention_options\x18\x04 \x01(\bR\x1dincludeSourceRetentionOptions\x12\x90\x01\n" +
	"\rinclude_types\x18\x05 \x03(\tBk\xbaHh\x92\x01e\"c\xba\x01`\n" +
	"\x14fqn_no_period_prefix\x121fully-qualified names should not start with a '.'\x1a\x15!this.startsWith('.')R\fincludeTypes\x12\x90\x01\n" +
	"\rexclude_types\x18\x06 \x03(\tBk\xbaHh\x92\x01e\"c\xba\x01`\n" +
	"\x14fqn_no_period_prefix\x121fully-qualified names should not start with a '.'\x1a\x15!this.startsWith('.')R\fexcludeTypes\"z\n" +
	"\x1cGetFileDescriptorSetResponse\x12Z\n" +
	"\x13file_descriptor_set\x18\x01 \x01(\v2\".google.protobuf.FileDescriptorSetB\x06\xbaH\x03\xc8\x01\x01R\x11fileDescriptorSet2\xa3\x01\n" +
	"\x18FileDescriptorSetService\x12\x86\x01\n" +
	"\x14GetFileDescriptorSet\x123.buf.registry.module.v1.GetFileDescriptorSetRequest\x1a4.buf.registry.module.v1.GetFileDescriptorSetResponse\"\x03\x90\x02\x01BWZUbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1;modulev1b\x06proto3"

var file_buf_registry_module_v1_file_descriptor_set_service_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_buf_registry_module_v1_file_descriptor_set_service_proto_goTypes = []any{
	(*GetFileDescriptorSetRequest)(nil),    // 0: buf.registry.module.v1.GetFileDescriptorSetRequest
	(*GetFileDescriptorSetResponse)(nil),   // 1: buf.registry.module.v1.GetFileDescriptorSetResponse
	(*ResourceRef)(nil),                    // 2: buf.registry.module.v1.ResourceRef
	(*descriptorpb.FileDescriptorSet)(nil), // 3: google.protobuf.FileDescriptorSet
}
var file_buf_registry_module_v1_file_descriptor_set_service_proto_depIdxs = []int32{
	2, // 0: buf.registry.module.v1.GetFileDescriptorSetRequest.resource_ref:type_name -> buf.registry.module.v1.ResourceRef
	3, // 1: buf.registry.module.v1.GetFileDescriptorSetResponse.file_descriptor_set:type_name -> google.protobuf.FileDescriptorSet
	0, // 2: buf.registry.module.v1.FileDescriptorSetService.GetFileDescriptorSet:input_type -> buf.registry.module.v1.GetFileDescriptorSetRequest
	1, // 3: buf.registry.module.v1.FileDescriptorSetService.GetFileDescriptorSet:output_type -> buf.registry.module.v1.GetFileDescriptorSetResponse
	3, // [3:4] is the sub-list for method output_type
	2, // [2:3] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_file_descriptor_set_service_proto_init() }
func file_buf_registry_module_v1_file_descriptor_set_service_proto_init() {
	if File_buf_registry_module_v1_file_descriptor_set_service_proto != nil {
		return
	}
	file_buf_registry_module_v1_resource_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1_file_descriptor_set_service_proto_rawDesc), len(file_buf_registry_module_v1_file_descriptor_set_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1_file_descriptor_set_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_file_descriptor_set_service_proto_depIdxs,
		MessageInfos:      file_buf_registry_module_v1_file_descriptor_set_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_file_descriptor_set_service_proto = out.File
	file_buf_registry_module_v1_file_descriptor_set_service_proto_goTypes = nil
	file_buf_registry_module_v1_file_descriptor_set_service_proto_depIdxs = nil
}
