// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.9
// 	protoc        (unknown)
// source: buf/plugin/descriptor/v1/file_location.proto

//go:build protoopaque

package descriptorv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A reference to a FileDescriptor or to a location within a FileDescriptor.
//
// A FileDescriptor is referenced by name.
// A location is referenced by its source path, following the semantics of
// google.protobuf.SourceCodeInfo.Location.path.
//
// A FileLocation may or may not include a source path. If a source path is not included, the
// FileLocation just references the FileDescriptor as a whole.
type FileLocation struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_FileName   string                 `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3"`
	xxx_hidden_SourcePath []int32                `protobuf:"varint,2,rep,packed,name=source_path,json=sourcePath,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *FileLocation) Reset() {
	*x = FileLocation{}
	mi := &file_buf_plugin_descriptor_v1_file_location_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileLocation) ProtoMessage() {}

func (x *FileLocation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_descriptor_v1_file_location_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FileLocation) GetFileName() string {
	if x != nil {
		return x.xxx_hidden_FileName
	}
	return ""
}

func (x *FileLocation) GetSourcePath() []int32 {
	if x != nil {
		return x.xxx_hidden_SourcePath
	}
	return nil
}

func (x *FileLocation) SetFileName(v string) {
	x.xxx_hidden_FileName = v
}

func (x *FileLocation) SetSourcePath(v []int32) {
	x.xxx_hidden_SourcePath = v
}

type FileLocation_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the FileDescriptor. This matches the name field in the corresponding FileDescriptorProto.
	//
	// Required.
	//
	// The path must be relative, and cannot contain any "." or ".." components.
	// The separator "/" must be used.
	FileName string
	// The SourceCodeInfo.Location.path within the FileDescriptorProto.
	//
	// This corresponds to a SourceCodeInfo.Location within the corresponding FileDescriptorProto.
	// Buf will find the first SourceCodeInfo.Location with this path, and use this to extract line
	// and column information, as well as read the comments for ignores.
	//
	// Optional. If not set, the Location just references the File as a whole.
	//
	// It is not valid to have a non-zero value of source_path without a name.
	SourcePath []int32
}

func (b0 FileLocation_builder) Build() *FileLocation {
	m0 := &FileLocation{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_FileName = b.FileName
	x.xxx_hidden_SourcePath = b.SourcePath
	return m0
}

var File_buf_plugin_descriptor_v1_file_location_proto protoreflect.FileDescriptor

const file_buf_plugin_descriptor_v1_file_location_proto_rawDesc = "" +
	"\n" +
	",buf/plugin/descriptor/v1/file_location.proto\x12\x18buf.plugin.descriptor.v1\x1a\x1bbuf/validate/validate.proto\"\xe0\x02\n" +
	"\fFileLocation\x12r\n" +
	"\tfile_name\x18\x01 \x01(\tBU\xbaHR\xc8\x01\x01rM\x18\x80 2D^([^/.][^/]?|[^/][^/.]|[^/]{3,})(/([^/.][^/]?|[^/][^/.]|[^/]{3,}))*$\xba\x01\x01\\R\bfileName\x12)\n" +
	"\vsource_path\x18\x02 \x03(\x05B\b\xbaH\x05\x92\x01\x02\x10@R\n" +
	"sourcePath:\xb0\x01\xbaH\xac\x01\x1a\xa9\x01\n" +
	"(file_name_present_if_source_path_present\x123file_name must be present if source_path is present\x1aH!has(this.source_path) || (has(this.source_path) && has(this.file_name))B^Z\\buf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/descriptor/v1;descriptorv1b\x06proto3"

var file_buf_plugin_descriptor_v1_file_location_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_buf_plugin_descriptor_v1_file_location_proto_goTypes = []any{
	(*FileLocation)(nil), // 0: buf.plugin.descriptor.v1.FileLocation
}
var file_buf_plugin_descriptor_v1_file_location_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_buf_plugin_descriptor_v1_file_location_proto_init() }
func file_buf_plugin_descriptor_v1_file_location_proto_init() {
	if File_buf_plugin_descriptor_v1_file_location_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_plugin_descriptor_v1_file_location_proto_rawDesc), len(file_buf_plugin_descriptor_v1_file_location_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_descriptor_v1_file_location_proto_goTypes,
		DependencyIndexes: file_buf_plugin_descriptor_v1_file_location_proto_depIdxs,
		MessageInfos:      file_buf_plugin_descriptor_v1_file_location_proto_msgTypes,
	}.Build()
	File_buf_plugin_descriptor_v1_file_location_proto = out.File
	file_buf_plugin_descriptor_v1_file_location_proto_goTypes = nil
	file_buf_plugin_descriptor_v1_file_location_proto_depIdxs = nil
}
