// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.8
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/plugin.proto

//go:build protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The visibility of a Plugin, currently either public or private.
type PluginVisibility int32

const (
	PluginVisibility_PLUGIN_VISIBILITY_UNSPECIFIED PluginVisibility = 0
	// PLUGIN_VISIBILITY_PUBLIC says that the plugin is publicly available.
	PluginVisibility_PLUGIN_VISIBILITY_PUBLIC PluginVisibility = 1
	// PLUGIN_VISIBILITY_PRIVATE says that the plugin is private.
	PluginVisibility_PLUGIN_VISIBILITY_PRIVATE PluginVisibility = 2
)

// Enum value maps for PluginVisibility.
var (
	PluginVisibility_name = map[int32]string{
		0: "PLUGIN_VISIBILITY_UNSPECIFIED",
		1: "PLUGIN_VISIBILITY_PUBLIC",
		2: "PLUGIN_VISIBILITY_PRIVATE",
	}
	PluginVisibility_value = map[string]int32{
		"PLUGIN_VISIBILITY_UNSPECIFIED": 0,
		"PLUGIN_VISIBILITY_PUBLIC":      1,
		"PLUGIN_VISIBILITY_PRIVATE":     2,
	}
)

func (x PluginVisibility) Enum() *PluginVisibility {
	p := new(PluginVisibility)
	*p = x
	return p
}

func (x PluginVisibility) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginVisibility) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes[0].Descriptor()
}

func (PluginVisibility) Type() protoreflect.EnumType {
	return &file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes[0]
}

func (x PluginVisibility) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The state of a Plugin, currently either active or deprecated.
type PluginState int32

const (
	PluginState_PLUGIN_STATE_UNSPECIFIED PluginState = 0
	// PLUGIN_STATE_ACTIVE says that the Plugin is currently active.
	PluginState_PLUGIN_STATE_ACTIVE PluginState = 1
	// PLUGIN_STATE_DEPRECATED says that the Plugin has been deprecated and should no longer be used.
	PluginState_PLUGIN_STATE_DEPRECATED PluginState = 2
)

// Enum value maps for PluginState.
var (
	PluginState_name = map[int32]string{
		0: "PLUGIN_STATE_UNSPECIFIED",
		1: "PLUGIN_STATE_ACTIVE",
		2: "PLUGIN_STATE_DEPRECATED",
	}
	PluginState_value = map[string]int32{
		"PLUGIN_STATE_UNSPECIFIED": 0,
		"PLUGIN_STATE_ACTIVE":      1,
		"PLUGIN_STATE_DEPRECATED":  2,
	}
)

func (x PluginState) Enum() *PluginState {
	p := new(PluginState)
	*p = x
	return p
}

func (x PluginState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginState) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes[1].Descriptor()
}

func (PluginState) Type() protoreflect.EnumType {
	return &file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes[1]
}

func (x PluginState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The type of the Plugin.
type PluginType int32

const (
	PluginType_PLUGIN_TYPE_UNSPECIFIED PluginType = 0
	// PLUGIN_TYPE_CHECK says that the Plugin is a check plugin.
	PluginType_PLUGIN_TYPE_CHECK PluginType = 1
)

// Enum value maps for PluginType.
var (
	PluginType_name = map[int32]string{
		0: "PLUGIN_TYPE_UNSPECIFIED",
		1: "PLUGIN_TYPE_CHECK",
	}
	PluginType_value = map[string]int32{
		"PLUGIN_TYPE_UNSPECIFIED": 0,
		"PLUGIN_TYPE_CHECK":       1,
	}
)

func (x PluginType) Enum() *PluginType {
	p := new(PluginType)
	*p = x
	return p
}

func (x PluginType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PluginType) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes[2].Descriptor()
}

func (PluginType) Type() protoreflect.EnumType {
	return &file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes[2]
}

func (x PluginType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Plugin struct {
	state                  protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id          string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime  *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime  *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Name        string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_OwnerId     string                 `protobuf:"bytes,5,opt,name=owner_id,json=ownerId,proto3"`
	xxx_hidden_Visibility  PluginVisibility       `protobuf:"varint,6,opt,name=visibility,proto3,enum=buf.registry.plugin.v1beta1.PluginVisibility"`
	xxx_hidden_State       PluginState            `protobuf:"varint,7,opt,name=state,proto3,enum=buf.registry.plugin.v1beta1.PluginState"`
	xxx_hidden_Type        PluginType             `protobuf:"varint,8,opt,name=type,proto3,enum=buf.registry.plugin.v1beta1.PluginType"`
	xxx_hidden_Description string                 `protobuf:"bytes,9,opt,name=description,proto3"`
	xxx_hidden_SourceUrl   string                 `protobuf:"bytes,10,opt,name=source_url,json=sourceUrl,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *Plugin) Reset() {
	*x = Plugin{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Plugin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Plugin) ProtoMessage() {}

func (x *Plugin) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Plugin) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Plugin) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Plugin) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *Plugin) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Plugin) GetOwnerId() string {
	if x != nil {
		return x.xxx_hidden_OwnerId
	}
	return ""
}

func (x *Plugin) GetVisibility() PluginVisibility {
	if x != nil {
		return x.xxx_hidden_Visibility
	}
	return PluginVisibility_PLUGIN_VISIBILITY_UNSPECIFIED
}

func (x *Plugin) GetState() PluginState {
	if x != nil {
		return x.xxx_hidden_State
	}
	return PluginState_PLUGIN_STATE_UNSPECIFIED
}

func (x *Plugin) GetType() PluginType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return PluginType_PLUGIN_TYPE_UNSPECIFIED
}

func (x *Plugin) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *Plugin) GetSourceUrl() string {
	if x != nil {
		return x.xxx_hidden_SourceUrl
	}
	return ""
}

func (x *Plugin) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Plugin) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Plugin) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *Plugin) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Plugin) SetOwnerId(v string) {
	x.xxx_hidden_OwnerId = v
}

func (x *Plugin) SetVisibility(v PluginVisibility) {
	x.xxx_hidden_Visibility = v
}

func (x *Plugin) SetState(v PluginState) {
	x.xxx_hidden_State = v
}

func (x *Plugin) SetType(v PluginType) {
	x.xxx_hidden_Type = v
}

func (x *Plugin) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *Plugin) SetSourceUrl(v string) {
	x.xxx_hidden_SourceUrl = v
}

func (x *Plugin) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Plugin) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *Plugin) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Plugin) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

type Plugin_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id of the Plugin.
	Id string
	// The time the Plugin was created on the BSR.
	CreateTime *timestamppb.Timestamp
	// The last time the Plugin was updated on the BSR.
	UpdateTime *timestamppb.Timestamp
	// The name of the Plugin.
	//
	// Unique within a given Organization.
	Name string
	// The id of the Organization that owns the Plugin.
	OwnerId string
	// The Plugin's visibility, either public or private.
	Visibility PluginVisibility
	// The Plugin state, either active or deprecated.
	State PluginState
	// The Plugin type.
	Type PluginType
	// The configurable short description of the Plugin.
	Description string
	// The configurable source URL of the Plugin.
	SourceUrl string
}

func (b0 Plugin_builder) Build() *Plugin {
	m0 := &Plugin{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_OwnerId = b.OwnerId
	x.xxx_hidden_Visibility = b.Visibility
	x.xxx_hidden_State = b.State
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_SourceUrl = b.SourceUrl
	return m0
}

// PluginRef is a reference to a Plugin, either an id or a fully-qualified name.
//
// This is used in requests.
type PluginRef struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value isPluginRef_Value      `protobuf_oneof:"value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *PluginRef) Reset() {
	*x = PluginRef{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginRef) ProtoMessage() {}

func (x *PluginRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PluginRef) GetId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*pluginRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *PluginRef) GetName() *PluginRef_Name {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*pluginRef_Name_); ok {
			return x.Name
		}
	}
	return nil
}

func (x *PluginRef) SetId(v string) {
	x.xxx_hidden_Value = &pluginRef_Id{v}
}

func (x *PluginRef) SetName(v *PluginRef_Name) {
	if v == nil {
		x.xxx_hidden_Value = nil
		return
	}
	x.xxx_hidden_Value = &pluginRef_Name_{v}
}

func (x *PluginRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *PluginRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*pluginRef_Id)
	return ok
}

func (x *PluginRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*pluginRef_Name_)
	return ok
}

func (x *PluginRef) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *PluginRef) ClearId() {
	if _, ok := x.xxx_hidden_Value.(*pluginRef_Id); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *PluginRef) ClearName() {
	if _, ok := x.xxx_hidden_Value.(*pluginRef_Name_); ok {
		x.xxx_hidden_Value = nil
	}
}

const PluginRef_Value_not_set_case case_PluginRef_Value = 0
const PluginRef_Id_case case_PluginRef_Value = 1
const PluginRef_Name_case case_PluginRef_Value = 2

func (x *PluginRef) WhichValue() case_PluginRef_Value {
	if x == nil {
		return PluginRef_Value_not_set_case
	}
	switch x.xxx_hidden_Value.(type) {
	case *pluginRef_Id:
		return PluginRef_Id_case
	case *pluginRef_Name_:
		return PluginRef_Name_case
	default:
		return PluginRef_Value_not_set_case
	}
}

type PluginRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Value:
	// The id of the Plugin.
	Id *string
	// The fully-qualified name of the Plugin.
	Name *PluginRef_Name
	// -- end of xxx_hidden_Value
}

func (b0 PluginRef_builder) Build() *PluginRef {
	m0 := &PluginRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.xxx_hidden_Value = &pluginRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.xxx_hidden_Value = &pluginRef_Name_{b.Name}
	}
	return m0
}

type case_PluginRef_Value protoreflect.FieldNumber

func (x case_PluginRef_Value) String() string {
	md := file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isPluginRef_Value interface {
	isPluginRef_Value()
}

type pluginRef_Id struct {
	// The id of the Plugin.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type pluginRef_Name_ struct {
	// The fully-qualified name of the Plugin.
	Name *PluginRef_Name `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*pluginRef_Id) isPluginRef_Value() {}

func (*pluginRef_Name_) isPluginRef_Value() {}

// The fully-qualified name of a Plugin within a BSR instance.
//
// A Name uniquely identifies a Plugin. This is used for requests when a caller only has the
// plugin name and not the ID.
type PluginRef_Name struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Owner  string                 `protobuf:"bytes,1,opt,name=owner,proto3"`
	xxx_hidden_Plugin string                 `protobuf:"bytes,2,opt,name=plugin,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *PluginRef_Name) Reset() {
	*x = PluginRef_Name{}
	mi := &file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PluginRef_Name) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PluginRef_Name) ProtoMessage() {}

func (x *PluginRef_Name) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PluginRef_Name) GetOwner() string {
	if x != nil {
		return x.xxx_hidden_Owner
	}
	return ""
}

func (x *PluginRef_Name) GetPlugin() string {
	if x != nil {
		return x.xxx_hidden_Plugin
	}
	return ""
}

func (x *PluginRef_Name) SetOwner(v string) {
	x.xxx_hidden_Owner = v
}

func (x *PluginRef_Name) SetPlugin(v string) {
	x.xxx_hidden_Plugin = v
}

type PluginRef_Name_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the Organization owner.
	Owner string
	// The name of the Plugin.
	Plugin string
}

func (b0 PluginRef_Name_builder) Build() *PluginRef_Name {
	m0 := &PluginRef_Name{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Owner = b.Owner
	x.xxx_hidden_Plugin = b.Plugin
	return m0
}

var File_buf_registry_plugin_v1beta1_plugin_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_plugin_proto_rawDesc = "" +
	"\n" +
	"(buf/registry/plugin/v1beta1/plugin.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xcc\x04\n" +
	"\x06Plugin\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12C\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"updateTime\x12\x1d\n" +
	"\x04name\x18\x04 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x04name\x12&\n" +
	"\bowner_id\x18\x05 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\aownerId\x12Z\n" +
	"\n" +
	"visibility\x18\x06 \x01(\x0e2-.buf.registry.plugin.v1beta1.PluginVisibilityB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\n" +
	"visibility\x12K\n" +
	"\x05state\x18\a \x01(\x0e2(.buf.registry.plugin.v1beta1.PluginStateB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x05state\x12H\n" +
	"\x04type\x18\b \x01(\x0e2'.buf.registry.plugin.v1beta1.PluginTypeB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x04type\x12*\n" +
	"\vdescription\x18\t \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12-\n" +
	"\n" +
	"source_url\x18\n" +
	" \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\tsourceUrl:\x06\xea\xc5+\x02\x10\x01\"\xcf\x01\n" +
	"\tPluginRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12A\n" +
	"\x04name\x18\x02 \x01(\v2+.buf.registry.plugin.v1beta1.PluginRef.NameH\x00R\x04name\x1aK\n" +
	"\x04Name\x12 \n" +
	"\x05owner\x18\x01 \x01(\tB\n" +
	"\xbaH\a\xc8\x01\x01r\x02\x18 R\x05owner\x12!\n" +
	"\x06plugin\x18\x02 \x01(\tB\t\xbaH\x06r\x04\x10\x02\x18dR\x06plugin:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01*r\n" +
	"\x10PluginVisibility\x12!\n" +
	"\x1dPLUGIN_VISIBILITY_UNSPECIFIED\x10\x00\x12\x1c\n" +
	"\x18PLUGIN_VISIBILITY_PUBLIC\x10\x01\x12\x1d\n" +
	"\x19PLUGIN_VISIBILITY_PRIVATE\x10\x02*a\n" +
	"\vPluginState\x12\x1c\n" +
	"\x18PLUGIN_STATE_UNSPECIFIED\x10\x00\x12\x17\n" +
	"\x13PLUGIN_STATE_ACTIVE\x10\x01\x12\x1b\n" +
	"\x17PLUGIN_STATE_DEPRECATED\x10\x02*@\n" +
	"\n" +
	"PluginType\x12\x1b\n" +
	"\x17PLUGIN_TYPE_UNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11PLUGIN_TYPE_CHECK\x10\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_registry_plugin_v1beta1_plugin_proto_goTypes = []any{
	(PluginVisibility)(0),         // 0: buf.registry.plugin.v1beta1.PluginVisibility
	(PluginState)(0),              // 1: buf.registry.plugin.v1beta1.PluginState
	(PluginType)(0),               // 2: buf.registry.plugin.v1beta1.PluginType
	(*Plugin)(nil),                // 3: buf.registry.plugin.v1beta1.Plugin
	(*PluginRef)(nil),             // 4: buf.registry.plugin.v1beta1.PluginRef
	(*PluginRef_Name)(nil),        // 5: buf.registry.plugin.v1beta1.PluginRef.Name
	(*timestamppb.Timestamp)(nil), // 6: google.protobuf.Timestamp
}
var file_buf_registry_plugin_v1beta1_plugin_proto_depIdxs = []int32{
	6, // 0: buf.registry.plugin.v1beta1.Plugin.create_time:type_name -> google.protobuf.Timestamp
	6, // 1: buf.registry.plugin.v1beta1.Plugin.update_time:type_name -> google.protobuf.Timestamp
	0, // 2: buf.registry.plugin.v1beta1.Plugin.visibility:type_name -> buf.registry.plugin.v1beta1.PluginVisibility
	1, // 3: buf.registry.plugin.v1beta1.Plugin.state:type_name -> buf.registry.plugin.v1beta1.PluginState
	2, // 4: buf.registry.plugin.v1beta1.Plugin.type:type_name -> buf.registry.plugin.v1beta1.PluginType
	5, // 5: buf.registry.plugin.v1beta1.PluginRef.name:type_name -> buf.registry.plugin.v1beta1.PluginRef.Name
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_plugin_proto_init() }
func file_buf_registry_plugin_v1beta1_plugin_proto_init() {
	if File_buf_registry_plugin_v1beta1_plugin_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes[1].OneofWrappers = []any{
		(*pluginRef_Id)(nil),
		(*pluginRef_Name_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_plugin_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_plugin_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_plugin_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_plugin_proto_depIdxs,
		EnumInfos:         file_buf_registry_plugin_v1beta1_plugin_proto_enumTypes,
		MessageInfos:      file_buf_registry_plugin_v1beta1_plugin_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_plugin_proto = out.File
	file_buf_registry_plugin_v1beta1_plugin_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_plugin_proto_depIdxs = nil
}
