// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.8
// 	protoc        (unknown)
// source: buf/registry/plugin/v1beta1/commit_service.proto

//go:build protoopaque

package pluginv1beta1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListCommitsRequest_Order int32

const (
	ListCommitsRequest_ORDER_UNSPECIFIED ListCommitsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListCommitsRequest_ORDER_CREATE_TIME_DESC ListCommitsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListCommitsRequest_ORDER_CREATE_TIME_ASC ListCommitsRequest_Order = 2
)

// Enum value maps for ListCommitsRequest_Order.
var (
	ListCommitsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListCommitsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListCommitsRequest_Order) Enum() *ListCommitsRequest_Order {
	p := new(ListCommitsRequest_Order)
	*p = x
	return p
}

func (x ListCommitsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListCommitsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_plugin_v1beta1_commit_service_proto_enumTypes[0].Descriptor()
}

func (ListCommitsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_plugin_v1beta1_commit_service_proto_enumTypes[0]
}

func (x ListCommitsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetCommitsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_ResourceRefs *[]*ResourceRef        `protobuf:"bytes,1,rep,name=resource_refs,json=resourceRefs,proto3"`
	xxx_hidden_DigestType   DigestType             `protobuf:"varint,2,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.plugin.v1beta1.DigestType"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *GetCommitsRequest) Reset() {
	*x = GetCommitsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCommitsRequest) ProtoMessage() {}

func (x *GetCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCommitsRequest) GetResourceRefs() []*ResourceRef {
	if x != nil {
		if x.xxx_hidden_ResourceRefs != nil {
			return *x.xxx_hidden_ResourceRefs
		}
	}
	return nil
}

func (x *GetCommitsRequest) GetDigestType() DigestType {
	if x != nil {
		return x.xxx_hidden_DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *GetCommitsRequest) SetResourceRefs(v []*ResourceRef) {
	x.xxx_hidden_ResourceRefs = &v
}

func (x *GetCommitsRequest) SetDigestType(v DigestType) {
	x.xxx_hidden_DigestType = v
}

type GetCommitsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// References to request a Commit for.
	//
	// See the documentation on ResourceRef for resource resolution details.
	//
	// Resolution is as follows:
	//   - If a Plugin is referenced, the Commit of the default Label is returned.
	//   - If a Label is referenced, the Commit of this Label is returned.
	//   - If a Commit is referenced, this Commit is returned.
	ResourceRefs []*ResourceRef
	// The DigestType to use for Digests returned on Commits.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used, currently P1.
	DigestType DigestType
}

func (b0 GetCommitsRequest_builder) Build() *GetCommitsRequest {
	m0 := &GetCommitsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_ResourceRefs = &b.ResourceRefs
	x.xxx_hidden_DigestType = b.DigestType
	return m0
}

type GetCommitsResponse struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Commits *[]*Commit             `protobuf:"bytes,1,rep,name=commits,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetCommitsResponse) Reset() {
	*x = GetCommitsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCommitsResponse) ProtoMessage() {}

func (x *GetCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetCommitsResponse) GetCommits() []*Commit {
	if x != nil {
		if x.xxx_hidden_Commits != nil {
			return *x.xxx_hidden_Commits
		}
	}
	return nil
}

func (x *GetCommitsResponse) SetCommits(v []*Commit) {
	x.xxx_hidden_Commits = &v
}

type GetCommitsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The found Commits in the same order as requested.
	Commits []*Commit
}

func (b0 GetCommitsResponse_builder) Build() *GetCommitsResponse {
	m0 := &GetCommitsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Commits = &b.Commits
	return m0
}

type ListCommitsRequest struct {
	state                  protoimpl.MessageState   `protogen:"opaque.v1"`
	xxx_hidden_PageSize    uint32                   `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken   string                   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_ResourceRef *ResourceRef             `protobuf:"bytes,3,opt,name=resource_ref,json=resourceRef,proto3"`
	xxx_hidden_Order       ListCommitsRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.plugin.v1beta1.ListCommitsRequest_Order"`
	xxx_hidden_DigestType  DigestType               `protobuf:"varint,5,opt,name=digest_type,json=digestType,proto3,enum=buf.registry.plugin.v1beta1.DigestType"`
	xxx_hidden_IdQuery     string                   `protobuf:"bytes,6,opt,name=id_query,json=idQuery,proto3"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ListCommitsRequest) Reset() {
	*x = ListCommitsRequest{}
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCommitsRequest) ProtoMessage() {}

func (x *ListCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCommitsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListCommitsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListCommitsRequest) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.xxx_hidden_ResourceRef
	}
	return nil
}

func (x *ListCommitsRequest) GetOrder() ListCommitsRequest_Order {
	if x != nil {
		return x.xxx_hidden_Order
	}
	return ListCommitsRequest_ORDER_UNSPECIFIED
}

func (x *ListCommitsRequest) GetDigestType() DigestType {
	if x != nil {
		return x.xxx_hidden_DigestType
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *ListCommitsRequest) GetIdQuery() string {
	if x != nil {
		return x.xxx_hidden_IdQuery
	}
	return ""
}

func (x *ListCommitsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListCommitsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListCommitsRequest) SetResourceRef(v *ResourceRef) {
	x.xxx_hidden_ResourceRef = v
}

func (x *ListCommitsRequest) SetOrder(v ListCommitsRequest_Order) {
	x.xxx_hidden_Order = v
}

func (x *ListCommitsRequest) SetDigestType(v DigestType) {
	x.xxx_hidden_DigestType = v
}

func (x *ListCommitsRequest) SetIdQuery(v string) {
	x.xxx_hidden_IdQuery = v
}

func (x *ListCommitsRequest) HasResourceRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ResourceRef != nil
}

func (x *ListCommitsRequest) ClearResourceRef() {
	x.xxx_hidden_ResourceRef = nil
}

type ListCommitsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The reference to list Commits for.
	//
	// See the documentation on Ref for resource resolution details.
	//
	// Once the resource is resolved, the following Commits are listed (subject to any additional filters in the request):
	//   - If a Plugin is referenced, all Commits for the Plugin are returned.
	//   - If a Label is referenced, the Commit the Label points to is returned.
	//     Use ListLabelHistory to get the history of Commits for a Label.
	//   - If a Commit is referenced, this Commit is returned.
	ResourceRef *ResourceRef
	// The order to return the Commits.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListCommitsRequest_Order
	// The DigestType to use for Digests returned on Commits.
	//
	// If this DigestType is not available, an error is returned.
	// Note that certain DigestTypes may be deprecated over time.
	//
	// If not set, the latest DigestType is used, currently p1.
	DigestType DigestType
	// Only return Commits with an id that contains this string using a case-insensitive comparison.
	IdQuery string
}

func (b0 ListCommitsRequest_builder) Build() *ListCommitsRequest {
	m0 := &ListCommitsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_ResourceRef = b.ResourceRef
	x.xxx_hidden_Order = b.Order
	x.xxx_hidden_DigestType = b.DigestType
	x.xxx_hidden_IdQuery = b.IdQuery
	return m0
}

type ListCommitsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3"`
	xxx_hidden_Commits       *[]*Commit             `protobuf:"bytes,2,rep,name=commits,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListCommitsResponse) Reset() {
	*x = ListCommitsResponse{}
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCommitsResponse) ProtoMessage() {}

func (x *ListCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListCommitsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListCommitsResponse) GetCommits() []*Commit {
	if x != nil {
		if x.xxx_hidden_Commits != nil {
			return *x.xxx_hidden_Commits
		}
	}
	return nil
}

func (x *ListCommitsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

func (x *ListCommitsResponse) SetCommits(v []*Commit) {
	x.xxx_hidden_Commits = &v
}

type ListCommitsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Commits.
	Commits []*Commit
}

func (b0 ListCommitsResponse_builder) Build() *ListCommitsResponse {
	m0 := &ListCommitsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_NextPageToken = b.NextPageToken
	x.xxx_hidden_Commits = &b.Commits
	return m0
}

var File_buf_registry_plugin_v1beta1_commit_service_proto protoreflect.FileDescriptor

const file_buf_registry_plugin_v1beta1_commit_service_proto_rawDesc = "" +
	"\n" +
	"0buf/registry/plugin/v1beta1/commit_service.proto\x12\x1bbuf.registry.plugin.v1beta1\x1a(buf/registry/plugin/v1beta1/commit.proto\x1a(buf/registry/plugin/v1beta1/digest.proto\x1a*buf/registry/plugin/v1beta1/resource.proto\x1a\x1bbuf/validate/validate.proto\"\xc3\x01\n" +
	"\x11GetCommitsRequest\x12Z\n" +
	"\rresource_refs\x18\x01 \x03(\v2(.buf.registry.plugin.v1beta1.ResourceRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\fresourceRefs\x12R\n" +
	"\vdigest_type\x18\x02 \x01(\x0e2'.buf.registry.plugin.v1beta1.DigestTypeB\b\xbaH\x05\x82\x01\x02\x10\x01R\n" +
	"digestType\"]\n" +
	"\x12GetCommitsResponse\x12G\n" +
	"\acommits\x18\x01 \x03(\v2#.buf.registry.plugin.v1beta1.CommitB\b\xbaH\x05\x92\x01\x02\b\x01R\acommits\"\xdf\x03\n" +
	"\x12ListCommitsRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12S\n" +
	"\fresource_ref\x18\x03 \x01(\v2(.buf.registry.plugin.v1beta1.ResourceRefB\x06\xbaH\x03\xc8\x01\x01R\vresourceRef\x12U\n" +
	"\x05order\x18\x04 \x01(\x0e25.buf.registry.plugin.v1beta1.ListCommitsRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\x12R\n" +
	"\vdigest_type\x18\x05 \x01(\x0e2'.buf.registry.plugin.v1beta1.DigestTypeB\b\xbaH\x05\x82\x01\x02\x10\x01R\n" +
	"digestType\x12\"\n" +
	"\bid_query\x18\x06 \x01(\tB\a\xbaH\x04r\x02\x18$R\aidQuery\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\"\x86\x01\n" +
	"\x13ListCommitsResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12=\n" +
	"\acommits\x18\x02 \x03(\v2#.buf.registry.plugin.v1beta1.CommitR\acommits2\xfa\x01\n" +
	"\rCommitService\x12r\n" +
	"\n" +
	"GetCommits\x12..buf.registry.plugin.v1beta1.GetCommitsRequest\x1a/.buf.registry.plugin.v1beta1.GetCommitsResponse\"\x03\x90\x02\x01\x12u\n" +
	"\vListCommits\x12/.buf.registry.plugin.v1beta1.ListCommitsRequest\x1a0.buf.registry.plugin.v1beta1.ListCommitsResponse\"\x03\x90\x02\x01BaZ_buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/plugin/v1beta1;pluginv1beta1b\x06proto3"

var file_buf_registry_plugin_v1beta1_commit_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_buf_registry_plugin_v1beta1_commit_service_proto_goTypes = []any{
	(ListCommitsRequest_Order)(0), // 0: buf.registry.plugin.v1beta1.ListCommitsRequest.Order
	(*GetCommitsRequest)(nil),     // 1: buf.registry.plugin.v1beta1.GetCommitsRequest
	(*GetCommitsResponse)(nil),    // 2: buf.registry.plugin.v1beta1.GetCommitsResponse
	(*ListCommitsRequest)(nil),    // 3: buf.registry.plugin.v1beta1.ListCommitsRequest
	(*ListCommitsResponse)(nil),   // 4: buf.registry.plugin.v1beta1.ListCommitsResponse
	(*ResourceRef)(nil),           // 5: buf.registry.plugin.v1beta1.ResourceRef
	(DigestType)(0),               // 6: buf.registry.plugin.v1beta1.DigestType
	(*Commit)(nil),                // 7: buf.registry.plugin.v1beta1.Commit
}
var file_buf_registry_plugin_v1beta1_commit_service_proto_depIdxs = []int32{
	5, // 0: buf.registry.plugin.v1beta1.GetCommitsRequest.resource_refs:type_name -> buf.registry.plugin.v1beta1.ResourceRef
	6, // 1: buf.registry.plugin.v1beta1.GetCommitsRequest.digest_type:type_name -> buf.registry.plugin.v1beta1.DigestType
	7, // 2: buf.registry.plugin.v1beta1.GetCommitsResponse.commits:type_name -> buf.registry.plugin.v1beta1.Commit
	5, // 3: buf.registry.plugin.v1beta1.ListCommitsRequest.resource_ref:type_name -> buf.registry.plugin.v1beta1.ResourceRef
	0, // 4: buf.registry.plugin.v1beta1.ListCommitsRequest.order:type_name -> buf.registry.plugin.v1beta1.ListCommitsRequest.Order
	6, // 5: buf.registry.plugin.v1beta1.ListCommitsRequest.digest_type:type_name -> buf.registry.plugin.v1beta1.DigestType
	7, // 6: buf.registry.plugin.v1beta1.ListCommitsResponse.commits:type_name -> buf.registry.plugin.v1beta1.Commit
	1, // 7: buf.registry.plugin.v1beta1.CommitService.GetCommits:input_type -> buf.registry.plugin.v1beta1.GetCommitsRequest
	3, // 8: buf.registry.plugin.v1beta1.CommitService.ListCommits:input_type -> buf.registry.plugin.v1beta1.ListCommitsRequest
	2, // 9: buf.registry.plugin.v1beta1.CommitService.GetCommits:output_type -> buf.registry.plugin.v1beta1.GetCommitsResponse
	4, // 10: buf.registry.plugin.v1beta1.CommitService.ListCommits:output_type -> buf.registry.plugin.v1beta1.ListCommitsResponse
	9, // [9:11] is the sub-list for method output_type
	7, // [7:9] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_buf_registry_plugin_v1beta1_commit_service_proto_init() }
func file_buf_registry_plugin_v1beta1_commit_service_proto_init() {
	if File_buf_registry_plugin_v1beta1_commit_service_proto != nil {
		return
	}
	file_buf_registry_plugin_v1beta1_commit_proto_init()
	file_buf_registry_plugin_v1beta1_digest_proto_init()
	file_buf_registry_plugin_v1beta1_resource_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_plugin_v1beta1_commit_service_proto_rawDesc), len(file_buf_registry_plugin_v1beta1_commit_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_plugin_v1beta1_commit_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_plugin_v1beta1_commit_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_plugin_v1beta1_commit_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_plugin_v1beta1_commit_service_proto_msgTypes,
	}.Build()
	File_buf_registry_plugin_v1beta1_commit_service_proto = out.File
	file_buf_registry_plugin_v1beta1_commit_service_proto_goTypes = nil
	file_buf_registry_plugin_v1beta1_commit_service_proto_depIdxs = nil
}
