// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.8
// 	protoc        (unknown)
// source: buf/registry/owner/v1/organization.proto

//go:build protoopaque

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	_ "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/priv/extension/v1beta1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The verification status of an Organization.
type OrganizationVerificationStatus int32

const (
	OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED OrganizationVerificationStatus = 0
	// The Organization is unverified.
	OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNVERIFIED OrganizationVerificationStatus = 1
	// The Organization is verified.
	OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_VERIFIED OrganizationVerificationStatus = 2
	// The Organization is an official organization of the BSR owner.
	OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_OFFICIAL OrganizationVerificationStatus = 3
)

// Enum value maps for OrganizationVerificationStatus.
var (
	OrganizationVerificationStatus_name = map[int32]string{
		0: "ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED",
		1: "ORGANIZATION_VERIFICATION_STATUS_UNVERIFIED",
		2: "ORGANIZATION_VERIFICATION_STATUS_VERIFIED",
		3: "ORGANIZATION_VERIFICATION_STATUS_OFFICIAL",
	}
	OrganizationVerificationStatus_value = map[string]int32{
		"ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED": 0,
		"ORGANIZATION_VERIFICATION_STATUS_UNVERIFIED":  1,
		"ORGANIZATION_VERIFICATION_STATUS_VERIFIED":    2,
		"ORGANIZATION_VERIFICATION_STATUS_OFFICIAL":    3,
	}
)

func (x OrganizationVerificationStatus) Enum() *OrganizationVerificationStatus {
	p := new(OrganizationVerificationStatus)
	*p = x
	return p
}

func (x OrganizationVerificationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrganizationVerificationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_organization_proto_enumTypes[0].Descriptor()
}

func (OrganizationVerificationStatus) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_organization_proto_enumTypes[0]
}

func (x OrganizationVerificationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Organization is an organization on the BSR.
//
// A name uniquely identifies an Organization, however name is mutable.
type Organization struct {
	state                         protoimpl.MessageState         `protogen:"opaque.v1"`
	xxx_hidden_Id                 string                         `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime         *timestamppb.Timestamp         `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_UpdateTime         *timestamppb.Timestamp         `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3"`
	xxx_hidden_Name               string                         `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_Description        string                         `protobuf:"bytes,5,opt,name=description,proto3"`
	xxx_hidden_Url                string                         `protobuf:"bytes,6,opt,name=url,proto3"`
	xxx_hidden_VerificationStatus OrganizationVerificationStatus `protobuf:"varint,7,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.OrganizationVerificationStatus"`
	unknownFields                 protoimpl.UnknownFields
	sizeCache                     protoimpl.SizeCache
}

func (x *Organization) Reset() {
	*x = Organization{}
	mi := &file_buf_registry_owner_v1_organization_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Organization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Organization) ProtoMessage() {}

func (x *Organization) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Organization) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Organization) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Organization) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_UpdateTime
	}
	return nil
}

func (x *Organization) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Organization) GetDescription() string {
	if x != nil {
		return x.xxx_hidden_Description
	}
	return ""
}

func (x *Organization) GetUrl() string {
	if x != nil {
		return x.xxx_hidden_Url
	}
	return ""
}

func (x *Organization) GetVerificationStatus() OrganizationVerificationStatus {
	if x != nil {
		return x.xxx_hidden_VerificationStatus
	}
	return OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *Organization) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Organization) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Organization) SetUpdateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_UpdateTime = v
}

func (x *Organization) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Organization) SetDescription(v string) {
	x.xxx_hidden_Description = v
}

func (x *Organization) SetUrl(v string) {
	x.xxx_hidden_Url = v
}

func (x *Organization) SetVerificationStatus(v OrganizationVerificationStatus) {
	x.xxx_hidden_VerificationStatus = v
}

func (x *Organization) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Organization) HasUpdateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_UpdateTime != nil
}

func (x *Organization) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Organization) ClearUpdateTime() {
	x.xxx_hidden_UpdateTime = nil
}

type Organization_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The id for the Organization.
	Id string
	// The time the Organization was created.
	CreateTime *timestamppb.Timestamp
	// The last time the Organization was updated.
	UpdateTime *timestamppb.Timestamp
	// The name of the Organization.
	//
	// A name uniquely identifies an Organization, however name is mutable.
	Name string
	// The configurable description of the Organization.
	Description string
	// The configurable URL that represents the homepage for an Organization.
	Url string
	// The verification status of the Organization.
	VerificationStatus OrganizationVerificationStatus
}

func (b0 Organization_builder) Build() *Organization {
	m0 := &Organization{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_UpdateTime = b.UpdateTime
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Description = b.Description
	x.xxx_hidden_Url = b.Url
	x.xxx_hidden_VerificationStatus = b.VerificationStatus
	return m0
}

// OrganizationRef is a reference to an Organization, either an id or a name.
//
// This is used in requests.
type OrganizationRef struct {
	state            protoimpl.MessageState  `protogen:"opaque.v1"`
	xxx_hidden_Value isOrganizationRef_Value `protobuf_oneof:"value"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *OrganizationRef) Reset() {
	*x = OrganizationRef{}
	mi := &file_buf_registry_owner_v1_organization_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrganizationRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrganizationRef) ProtoMessage() {}

func (x *OrganizationRef) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OrganizationRef) GetId() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*organizationRef_Id); ok {
			return x.Id
		}
	}
	return ""
}

func (x *OrganizationRef) GetName() string {
	if x != nil {
		if x, ok := x.xxx_hidden_Value.(*organizationRef_Name); ok {
			return x.Name
		}
	}
	return ""
}

func (x *OrganizationRef) SetId(v string) {
	x.xxx_hidden_Value = &organizationRef_Id{v}
}

func (x *OrganizationRef) SetName(v string) {
	x.xxx_hidden_Value = &organizationRef_Name{v}
}

func (x *OrganizationRef) HasValue() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Value != nil
}

func (x *OrganizationRef) HasId() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*organizationRef_Id)
	return ok
}

func (x *OrganizationRef) HasName() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Value.(*organizationRef_Name)
	return ok
}

func (x *OrganizationRef) ClearValue() {
	x.xxx_hidden_Value = nil
}

func (x *OrganizationRef) ClearId() {
	if _, ok := x.xxx_hidden_Value.(*organizationRef_Id); ok {
		x.xxx_hidden_Value = nil
	}
}

func (x *OrganizationRef) ClearName() {
	if _, ok := x.xxx_hidden_Value.(*organizationRef_Name); ok {
		x.xxx_hidden_Value = nil
	}
}

const OrganizationRef_Value_not_set_case case_OrganizationRef_Value = 0
const OrganizationRef_Id_case case_OrganizationRef_Value = 1
const OrganizationRef_Name_case case_OrganizationRef_Value = 2

func (x *OrganizationRef) WhichValue() case_OrganizationRef_Value {
	if x == nil {
		return OrganizationRef_Value_not_set_case
	}
	switch x.xxx_hidden_Value.(type) {
	case *organizationRef_Id:
		return OrganizationRef_Id_case
	case *organizationRef_Name:
		return OrganizationRef_Name_case
	default:
		return OrganizationRef_Value_not_set_case
	}
}

type OrganizationRef_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Value:
	// The id of the Organization.
	Id *string
	// The name of the Organization.
	Name *string
	// -- end of xxx_hidden_Value
}

func (b0 OrganizationRef_builder) Build() *OrganizationRef {
	m0 := &OrganizationRef{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Id != nil {
		x.xxx_hidden_Value = &organizationRef_Id{*b.Id}
	}
	if b.Name != nil {
		x.xxx_hidden_Value = &organizationRef_Name{*b.Name}
	}
	return m0
}

type case_OrganizationRef_Value protoreflect.FieldNumber

func (x case_OrganizationRef_Value) String() string {
	md := file_buf_registry_owner_v1_organization_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isOrganizationRef_Value interface {
	isOrganizationRef_Value()
}

type organizationRef_Id struct {
	// The id of the Organization.
	Id string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}

type organizationRef_Name struct {
	// The name of the Organization.
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*organizationRef_Id) isOrganizationRef_Value() {}

func (*organizationRef_Name) isOrganizationRef_Value() {}

var File_buf_registry_owner_v1_organization_proto protoreflect.FileDescriptor

const file_buf_registry_owner_v1_organization_proto_rawDesc = "" +
	"\n" +
	"(buf/registry/owner/v1/organization.proto\x12\x15buf.registry.owner.v1\x1a3buf/registry/priv/extension/v1beta1/extension.proto\x1a\x1bbuf/validate/validate.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xbd\x03\n" +
	"\fOrganization\x12\x1b\n" +
	"\x02id\x18\x01 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\x02id\x12C\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"createTime\x12C\n" +
	"\vupdate_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x06\xbaH\x03\xc8\x01\x01R\n" +
	"updateTime\x12;\n" +
	"\x04name\x18\x04 \x01(\tB'\xbaH$\xc8\x01\x01r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$R\x04name\x12*\n" +
	"\vdescription\x18\x05 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12 \n" +
	"\x03url\x18\x06 \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x03url\x12s\n" +
	"\x13verification_status\x18\a \x01(\x0e25.buf.registry.owner.v1.OrganizationVerificationStatusB\v\xbaH\b\xc8\x01\x01\x82\x01\x02\x10\x01R\x12verificationStatus:\x06\xea\xc5+\x02\x10\x01\"\x81\x01\n" +
	"\x0fOrganizationRef\x12\x1a\n" +
	"\x02id\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x88\x02\x01H\x00R\x02id\x12:\n" +
	"\x04name\x18\x02 \x01(\tB$\xbaH!r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$H\x00R\x04name:\x06\xea\xc5+\x02\b\x01B\x0e\n" +
	"\x05value\x12\x05\xbaH\x02\b\x01*\xe1\x01\n" +
	"\x1eOrganizationVerificationStatus\x120\n" +
	",ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED\x10\x00\x12/\n" +
	"+ORGANIZATION_VERIFICATION_STATUS_UNVERIFIED\x10\x01\x12-\n" +
	")ORGANIZATION_VERIFICATION_STATUS_VERIFIED\x10\x02\x12-\n" +
	")ORGANIZATION_VERIFICATION_STATUS_OFFICIAL\x10\x03BUZSbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1;ownerv1b\x06proto3"

var file_buf_registry_owner_v1_organization_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_owner_v1_organization_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_buf_registry_owner_v1_organization_proto_goTypes = []any{
	(OrganizationVerificationStatus)(0), // 0: buf.registry.owner.v1.OrganizationVerificationStatus
	(*Organization)(nil),                // 1: buf.registry.owner.v1.Organization
	(*OrganizationRef)(nil),             // 2: buf.registry.owner.v1.OrganizationRef
	(*timestamppb.Timestamp)(nil),       // 3: google.protobuf.Timestamp
}
var file_buf_registry_owner_v1_organization_proto_depIdxs = []int32{
	3, // 0: buf.registry.owner.v1.Organization.create_time:type_name -> google.protobuf.Timestamp
	3, // 1: buf.registry.owner.v1.Organization.update_time:type_name -> google.protobuf.Timestamp
	0, // 2: buf.registry.owner.v1.Organization.verification_status:type_name -> buf.registry.owner.v1.OrganizationVerificationStatus
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_organization_proto_init() }
func file_buf_registry_owner_v1_organization_proto_init() {
	if File_buf_registry_owner_v1_organization_proto != nil {
		return
	}
	file_buf_registry_owner_v1_organization_proto_msgTypes[1].OneofWrappers = []any{
		(*organizationRef_Id)(nil),
		(*organizationRef_Name)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_owner_v1_organization_proto_rawDesc), len(file_buf_registry_owner_v1_organization_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_registry_owner_v1_organization_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_organization_proto_depIdxs,
		EnumInfos:         file_buf_registry_owner_v1_organization_proto_enumTypes,
		MessageInfos:      file_buf_registry_owner_v1_organization_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_organization_proto = out.File
	file_buf_registry_owner_v1_organization_proto_goTypes = nil
	file_buf_registry_owner_v1_organization_proto_depIdxs = nil
}
