// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.8
// 	protoc        (unknown)
// source: buf/registry/module/v1/label_service.proto

//go:build protoopaque

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListLabelsRequest_Order int32

const (
	ListLabelsRequest_ORDER_UNSPECIFIED ListLabelsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListLabelsRequest_ORDER_CREATE_TIME_DESC ListLabelsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListLabelsRequest_ORDER_CREATE_TIME_ASC ListLabelsRequest_Order = 2
	// Order by update_time newest to oldest.
	ListLabelsRequest_ORDER_UPDATE_TIME_DESC ListLabelsRequest_Order = 3
	// Order by update_time oldest to newest.
	ListLabelsRequest_ORDER_UPDATE_TIME_ASC ListLabelsRequest_Order = 4
)

// Enum value maps for ListLabelsRequest_Order.
var (
	ListLabelsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
		3: "ORDER_UPDATE_TIME_DESC",
		4: "ORDER_UPDATE_TIME_ASC",
	}
	ListLabelsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
		"ORDER_UPDATE_TIME_DESC": 3,
		"ORDER_UPDATE_TIME_ASC":  4,
	}
)

func (x ListLabelsRequest_Order) Enum() *ListLabelsRequest_Order {
	p := new(ListLabelsRequest_Order)
	*p = x
	return p
}

func (x ListLabelsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListLabelsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_label_service_proto_enumTypes[0].Descriptor()
}

func (ListLabelsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_label_service_proto_enumTypes[0]
}

func (x ListLabelsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// A filter on whether a Label is archived or not.
type ListLabelsRequest_ArchiveFilter int32

const (
	ListLabelsRequest_ARCHIVE_FILTER_UNSPECIFIED ListLabelsRequest_ArchiveFilter = 0
	// Return only unarchived labels.
	ListLabelsRequest_ARCHIVE_FILTER_UNARCHIVED_ONLY ListLabelsRequest_ArchiveFilter = 1
	// Return only archived labels.
	ListLabelsRequest_ARCHIVE_FILTER_ARCHIVED_ONLY ListLabelsRequest_ArchiveFilter = 2
	// Return both archived and unarchived labels.
	ListLabelsRequest_ARCHIVE_FILTER_ALL ListLabelsRequest_ArchiveFilter = 3
)

// Enum value maps for ListLabelsRequest_ArchiveFilter.
var (
	ListLabelsRequest_ArchiveFilter_name = map[int32]string{
		0: "ARCHIVE_FILTER_UNSPECIFIED",
		1: "ARCHIVE_FILTER_UNARCHIVED_ONLY",
		2: "ARCHIVE_FILTER_ARCHIVED_ONLY",
		3: "ARCHIVE_FILTER_ALL",
	}
	ListLabelsRequest_ArchiveFilter_value = map[string]int32{
		"ARCHIVE_FILTER_UNSPECIFIED":     0,
		"ARCHIVE_FILTER_UNARCHIVED_ONLY": 1,
		"ARCHIVE_FILTER_ARCHIVED_ONLY":   2,
		"ARCHIVE_FILTER_ALL":             3,
	}
)

func (x ListLabelsRequest_ArchiveFilter) Enum() *ListLabelsRequest_ArchiveFilter {
	p := new(ListLabelsRequest_ArchiveFilter)
	*p = x
	return p
}

func (x ListLabelsRequest_ArchiveFilter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListLabelsRequest_ArchiveFilter) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_label_service_proto_enumTypes[1].Descriptor()
}

func (ListLabelsRequest_ArchiveFilter) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_label_service_proto_enumTypes[1]
}

func (x ListLabelsRequest_ArchiveFilter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// The list order.
type ListLabelHistoryRequest_Order int32

const (
	ListLabelHistoryRequest_ORDER_UNSPECIFIED ListLabelHistoryRequest_Order = 0
	// Order by association time newest to oldest.
	//
	// The Commits most recently associated with the Label will be listed first.
	ListLabelHistoryRequest_ORDER_DESC ListLabelHistoryRequest_Order = 1
	// Order by association time oldest to newest.
	ListLabelHistoryRequest_ORDER_ASC ListLabelHistoryRequest_Order = 2
)

// Enum value maps for ListLabelHistoryRequest_Order.
var (
	ListLabelHistoryRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_DESC",
		2: "ORDER_ASC",
	}
	ListLabelHistoryRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED": 0,
		"ORDER_DESC":        1,
		"ORDER_ASC":         2,
	}
)

func (x ListLabelHistoryRequest_Order) Enum() *ListLabelHistoryRequest_Order {
	p := new(ListLabelHistoryRequest_Order)
	*p = x
	return p
}

func (x ListLabelHistoryRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListLabelHistoryRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_label_service_proto_enumTypes[2].Descriptor()
}

func (ListLabelHistoryRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_label_service_proto_enumTypes[2]
}

func (x ListLabelHistoryRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetLabelsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_LabelRefs *[]*LabelRef           `protobuf:"bytes,1,rep,name=label_refs,json=labelRefs,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GetLabelsRequest) Reset() {
	*x = GetLabelsRequest{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelsRequest) ProtoMessage() {}

func (x *GetLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLabelsRequest) GetLabelRefs() []*LabelRef {
	if x != nil {
		if x.xxx_hidden_LabelRefs != nil {
			return *x.xxx_hidden_LabelRefs
		}
	}
	return nil
}

func (x *GetLabelsRequest) SetLabelRefs(v []*LabelRef) {
	x.xxx_hidden_LabelRefs = &v
}

type GetLabelsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Labels to request.
	//
	// This may reference archived Labels.
	LabelRefs []*LabelRef
}

func (b0 GetLabelsRequest_builder) Build() *GetLabelsRequest {
	m0 := &GetLabelsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LabelRefs = &b.LabelRefs
	return m0
}

type GetLabelsResponse struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Labels *[]*Label              `protobuf:"bytes,1,rep,name=labels,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *GetLabelsResponse) Reset() {
	*x = GetLabelsResponse{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelsResponse) ProtoMessage() {}

func (x *GetLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetLabelsResponse) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *GetLabelsResponse) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

type GetLabelsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Labels in the same order as requested.
	Labels []*Label
}

func (b0 GetLabelsResponse_builder) Build() *GetLabelsResponse {
	m0 := &GetLabelsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Labels = &b.Labels
	return m0
}

type ListLabelsRequest struct {
	state                          protoimpl.MessageState          `protogen:"opaque.v1"`
	xxx_hidden_PageSize            uint32                          `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken           string                          `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_ResourceRef         *ResourceRef                    `protobuf:"bytes,3,opt,name=resource_ref,json=resourceRef,proto3"`
	xxx_hidden_Order               ListLabelsRequest_Order         `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1.ListLabelsRequest_Order"`
	xxx_hidden_CommitCheckStatuses []CommitCheckStatus             `protobuf:"varint,5,rep,packed,name=commit_check_statuses,json=commitCheckStatuses,proto3,enum=buf.registry.module.v1.CommitCheckStatus"`
	xxx_hidden_NameQuery           string                          `protobuf:"bytes,6,opt,name=name_query,json=nameQuery,proto3"`
	xxx_hidden_ArchiveFilter       ListLabelsRequest_ArchiveFilter `protobuf:"varint,7,opt,name=archive_filter,json=archiveFilter,proto3,enum=buf.registry.module.v1.ListLabelsRequest_ArchiveFilter"`
	unknownFields                  protoimpl.UnknownFields
	sizeCache                      protoimpl.SizeCache
}

func (x *ListLabelsRequest) Reset() {
	*x = ListLabelsRequest{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsRequest) ProtoMessage() {}

func (x *ListLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListLabelsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListLabelsRequest) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.xxx_hidden_ResourceRef
	}
	return nil
}

func (x *ListLabelsRequest) GetOrder() ListLabelsRequest_Order {
	if x != nil {
		return x.xxx_hidden_Order
	}
	return ListLabelsRequest_ORDER_UNSPECIFIED
}

func (x *ListLabelsRequest) GetCommitCheckStatuses() []CommitCheckStatus {
	if x != nil {
		return x.xxx_hidden_CommitCheckStatuses
	}
	return nil
}

func (x *ListLabelsRequest) GetNameQuery() string {
	if x != nil {
		return x.xxx_hidden_NameQuery
	}
	return ""
}

func (x *ListLabelsRequest) GetArchiveFilter() ListLabelsRequest_ArchiveFilter {
	if x != nil {
		return x.xxx_hidden_ArchiveFilter
	}
	return ListLabelsRequest_ARCHIVE_FILTER_UNSPECIFIED
}

func (x *ListLabelsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListLabelsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListLabelsRequest) SetResourceRef(v *ResourceRef) {
	x.xxx_hidden_ResourceRef = v
}

func (x *ListLabelsRequest) SetOrder(v ListLabelsRequest_Order) {
	x.xxx_hidden_Order = v
}

func (x *ListLabelsRequest) SetCommitCheckStatuses(v []CommitCheckStatus) {
	x.xxx_hidden_CommitCheckStatuses = v
}

func (x *ListLabelsRequest) SetNameQuery(v string) {
	x.xxx_hidden_NameQuery = v
}

func (x *ListLabelsRequest) SetArchiveFilter(v ListLabelsRequest_ArchiveFilter) {
	x.xxx_hidden_ArchiveFilter = v
}

func (x *ListLabelsRequest) HasResourceRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ResourceRef != nil
}

func (x *ListLabelsRequest) ClearResourceRef() {
	x.xxx_hidden_ResourceRef = nil
}

type ListLabelsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The reference to list Labels for.
	//
	// See the documentation on Ref for resource resolution details.
	//
	// Once the resource is resolved, the following Labels are listed (subject to any additional filters in the request):
	//   - If a Module is referenced, all Labels for the Module are returned.
	//   - If a Label is referenced, this Label is returned.
	//   - If a Commit is referenced, all Labels that currently point to the Commit are returned. Note that
	//     Labels only point to passed or approved Commits, or Commits where policy checks were disabled.
	ResourceRef *ResourceRef
	// The order to return the Labels.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListLabelsRequest_Order
	// Only return Labels that point to a Commit with one of these CommitCheckStatus values.
	//
	// If not set, Labels that point to a Commit with any CommitCheckStatus value are returned.
	//
	// It is an error to filter on CommitCheckStatuses of pending or rejected, as Labels will only
	// point to Commits that are passed or approved, or that have policy checks disabled.
	CommitCheckStatuses []CommitCheckStatus
	// Only return Labels with a name that contains this string using a case-insensitive comparison.
	NameQuery string
	// The archive filter on the returned Labels.
	//
	// If not specified, defaults to ARCHIVE_FILTER_UNARCHIVED_ONLY.
	ArchiveFilter ListLabelsRequest_ArchiveFilter
}

func (b0 ListLabelsRequest_builder) Build() *ListLabelsRequest {
	m0 := &ListLabelsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_ResourceRef = b.ResourceRef
	x.xxx_hidden_Order = b.Order
	x.xxx_hidden_CommitCheckStatuses = b.CommitCheckStatuses
	x.xxx_hidden_NameQuery = b.NameQuery
	x.xxx_hidden_ArchiveFilter = b.ArchiveFilter
	return m0
}

type ListLabelsResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3"`
	xxx_hidden_Labels        *[]*Label              `protobuf:"bytes,2,rep,name=labels,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListLabelsResponse) Reset() {
	*x = ListLabelsResponse{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsResponse) ProtoMessage() {}

func (x *ListLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListLabelsResponse) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *ListLabelsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

func (x *ListLabelsResponse) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

type ListLabelsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Labels.
	Labels []*Label
}

func (b0 ListLabelsResponse_builder) Build() *ListLabelsResponse {
	m0 := &ListLabelsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_NextPageToken = b.NextPageToken
	x.xxx_hidden_Labels = &b.Labels
	return m0
}

type ListLabelHistoryRequest struct {
	state                                    protoimpl.MessageState        `protogen:"opaque.v1"`
	xxx_hidden_PageSize                      uint32                        `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken                     string                        `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_LabelRef                      *LabelRef                     `protobuf:"bytes,3,opt,name=label_ref,json=labelRef,proto3"`
	xxx_hidden_Order                         ListLabelHistoryRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1.ListLabelHistoryRequest_Order"`
	xxx_hidden_CommitCheckStatuses           []CommitCheckStatus           `protobuf:"varint,5,rep,packed,name=commit_check_statuses,json=commitCheckStatuses,proto3,enum=buf.registry.module.v1.CommitCheckStatus"`
	xxx_hidden_StartCommitId                 string                        `protobuf:"bytes,6,opt,name=start_commit_id,json=startCommitId,proto3"`
	xxx_hidden_OnlyCommitsWithChangedDigests bool                          `protobuf:"varint,7,opt,name=only_commits_with_changed_digests,json=onlyCommitsWithChangedDigests,proto3"`
	unknownFields                            protoimpl.UnknownFields
	sizeCache                                protoimpl.SizeCache
}

func (x *ListLabelHistoryRequest) Reset() {
	*x = ListLabelHistoryRequest{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLabelHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelHistoryRequest) ProtoMessage() {}

func (x *ListLabelHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListLabelHistoryRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListLabelHistoryRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListLabelHistoryRequest) GetLabelRef() *LabelRef {
	if x != nil {
		return x.xxx_hidden_LabelRef
	}
	return nil
}

func (x *ListLabelHistoryRequest) GetOrder() ListLabelHistoryRequest_Order {
	if x != nil {
		return x.xxx_hidden_Order
	}
	return ListLabelHistoryRequest_ORDER_UNSPECIFIED
}

func (x *ListLabelHistoryRequest) GetCommitCheckStatuses() []CommitCheckStatus {
	if x != nil {
		return x.xxx_hidden_CommitCheckStatuses
	}
	return nil
}

func (x *ListLabelHistoryRequest) GetStartCommitId() string {
	if x != nil {
		return x.xxx_hidden_StartCommitId
	}
	return ""
}

func (x *ListLabelHistoryRequest) GetOnlyCommitsWithChangedDigests() bool {
	if x != nil {
		return x.xxx_hidden_OnlyCommitsWithChangedDigests
	}
	return false
}

func (x *ListLabelHistoryRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListLabelHistoryRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListLabelHistoryRequest) SetLabelRef(v *LabelRef) {
	x.xxx_hidden_LabelRef = v
}

func (x *ListLabelHistoryRequest) SetOrder(v ListLabelHistoryRequest_Order) {
	x.xxx_hidden_Order = v
}

func (x *ListLabelHistoryRequest) SetCommitCheckStatuses(v []CommitCheckStatus) {
	x.xxx_hidden_CommitCheckStatuses = v
}

func (x *ListLabelHistoryRequest) SetStartCommitId(v string) {
	x.xxx_hidden_StartCommitId = v
}

func (x *ListLabelHistoryRequest) SetOnlyCommitsWithChangedDigests(v bool) {
	x.xxx_hidden_OnlyCommitsWithChangedDigests = v
}

func (x *ListLabelHistoryRequest) HasLabelRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LabelRef != nil
}

func (x *ListLabelHistoryRequest) ClearLabelRef() {
	x.xxx_hidden_LabelRef = nil
}

type ListLabelHistoryRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The Label to list history for.
	//
	// This may reference archived Labels.
	LabelRef *LabelRef
	// The order to list the Labels.
	//
	// If not specified, defaults to ORDER_DESC.
	Order ListLabelHistoryRequest_Order
	// Only return Commits that have one of these CommitCheckStatus values for this label.
	//
	// If not set, Commits with any CommitCheckStatus value are returned.
	CommitCheckStatuses []CommitCheckStatus
	// The Commit id to start from.
	//
	// It is an error to provide a Commit id that doesn't exist on the Label.
	StartCommitId string
	// Only list Commits where the Digest has changed from the previous Commit in the
	// history of this Label.
	OnlyCommitsWithChangedDigests bool
}

func (b0 ListLabelHistoryRequest_builder) Build() *ListLabelHistoryRequest {
	m0 := &ListLabelHistoryRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_LabelRef = b.LabelRef
	x.xxx_hidden_Order = b.Order
	x.xxx_hidden_CommitCheckStatuses = b.CommitCheckStatuses
	x.xxx_hidden_StartCommitId = b.StartCommitId
	x.xxx_hidden_OnlyCommitsWithChangedDigests = b.OnlyCommitsWithChangedDigests
	return m0
}

type ListLabelHistoryResponse struct {
	state                    protoimpl.MessageState             `protogen:"opaque.v1"`
	xxx_hidden_NextPageToken string                             `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3"`
	xxx_hidden_Values        *[]*ListLabelHistoryResponse_Value `protobuf:"bytes,2,rep,name=values,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListLabelHistoryResponse) Reset() {
	*x = ListLabelHistoryResponse{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLabelHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelHistoryResponse) ProtoMessage() {}

func (x *ListLabelHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListLabelHistoryResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListLabelHistoryResponse) GetValues() []*ListLabelHistoryResponse_Value {
	if x != nil {
		if x.xxx_hidden_Values != nil {
			return *x.xxx_hidden_Values
		}
	}
	return nil
}

func (x *ListLabelHistoryResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

func (x *ListLabelHistoryResponse) SetValues(v []*ListLabelHistoryResponse_Value) {
	x.xxx_hidden_Values = &v
}

type ListLabelHistoryResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The ordered history of the Label.
	Values []*ListLabelHistoryResponse_Value
}

func (b0 ListLabelHistoryResponse_builder) Build() *ListLabelHistoryResponse {
	m0 := &ListLabelHistoryResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_NextPageToken = b.NextPageToken
	x.xxx_hidden_Values = &b.Values
	return m0
}

type CreateOrUpdateLabelsRequest struct {
	state             protoimpl.MessageState                `protogen:"opaque.v1"`
	xxx_hidden_Values *[]*CreateOrUpdateLabelsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CreateOrUpdateLabelsRequest) Reset() {
	*x = CreateOrUpdateLabelsRequest{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrUpdateLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrUpdateLabelsRequest) ProtoMessage() {}

func (x *CreateOrUpdateLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrUpdateLabelsRequest) GetValues() []*CreateOrUpdateLabelsRequest_Value {
	if x != nil {
		if x.xxx_hidden_Values != nil {
			return *x.xxx_hidden_Values
		}
	}
	return nil
}

func (x *CreateOrUpdateLabelsRequest) SetValues(v []*CreateOrUpdateLabelsRequest_Value) {
	x.xxx_hidden_Values = &v
}

type CreateOrUpdateLabelsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Labels to create.
	Values []*CreateOrUpdateLabelsRequest_Value
}

func (b0 CreateOrUpdateLabelsRequest_builder) Build() *CreateOrUpdateLabelsRequest {
	m0 := &CreateOrUpdateLabelsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Values = &b.Values
	return m0
}

type CreateOrUpdateLabelsResponse struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Labels *[]*Label              `protobuf:"bytes,1,rep,name=labels,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *CreateOrUpdateLabelsResponse) Reset() {
	*x = CreateOrUpdateLabelsResponse{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrUpdateLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrUpdateLabelsResponse) ProtoMessage() {}

func (x *CreateOrUpdateLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrUpdateLabelsResponse) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *CreateOrUpdateLabelsResponse) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

type CreateOrUpdateLabelsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The created or updated Labels in the same order as given on the request.
	Labels []*Label
}

func (b0 CreateOrUpdateLabelsResponse_builder) Build() *CreateOrUpdateLabelsResponse {
	m0 := &CreateOrUpdateLabelsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Labels = &b.Labels
	return m0
}

type ArchiveLabelsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_LabelRefs *[]*LabelRef           `protobuf:"bytes,1,rep,name=label_refs,json=labelRefs,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ArchiveLabelsRequest) Reset() {
	*x = ArchiveLabelsRequest{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArchiveLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveLabelsRequest) ProtoMessage() {}

func (x *ArchiveLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ArchiveLabelsRequest) GetLabelRefs() []*LabelRef {
	if x != nil {
		if x.xxx_hidden_LabelRefs != nil {
			return *x.xxx_hidden_LabelRefs
		}
	}
	return nil
}

func (x *ArchiveLabelsRequest) SetLabelRefs(v []*LabelRef) {
	x.xxx_hidden_LabelRefs = &v
}

type ArchiveLabelsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Labels to archive.
	LabelRefs []*LabelRef
}

func (b0 ArchiveLabelsRequest_builder) Build() *ArchiveLabelsRequest {
	m0 := &ArchiveLabelsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LabelRefs = &b.LabelRefs
	return m0
}

type ArchiveLabelsResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ArchiveLabelsResponse) Reset() {
	*x = ArchiveLabelsResponse{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArchiveLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveLabelsResponse) ProtoMessage() {}

func (x *ArchiveLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type ArchiveLabelsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 ArchiveLabelsResponse_builder) Build() *ArchiveLabelsResponse {
	m0 := &ArchiveLabelsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type UnarchiveLabelsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_LabelRefs *[]*LabelRef           `protobuf:"bytes,1,rep,name=label_refs,json=labelRefs,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *UnarchiveLabelsRequest) Reset() {
	*x = UnarchiveLabelsRequest{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnarchiveLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveLabelsRequest) ProtoMessage() {}

func (x *UnarchiveLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UnarchiveLabelsRequest) GetLabelRefs() []*LabelRef {
	if x != nil {
		if x.xxx_hidden_LabelRefs != nil {
			return *x.xxx_hidden_LabelRefs
		}
	}
	return nil
}

func (x *UnarchiveLabelsRequest) SetLabelRefs(v []*LabelRef) {
	x.xxx_hidden_LabelRefs = &v
}

type UnarchiveLabelsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Labels to unarchive.
	LabelRefs []*LabelRef
}

func (b0 UnarchiveLabelsRequest_builder) Build() *UnarchiveLabelsRequest {
	m0 := &UnarchiveLabelsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LabelRefs = &b.LabelRefs
	return m0
}

type UnarchiveLabelsResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UnarchiveLabelsResponse) Reset() {
	*x = UnarchiveLabelsResponse{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnarchiveLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveLabelsResponse) ProtoMessage() {}

func (x *UnarchiveLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type UnarchiveLabelsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 UnarchiveLabelsResponse_builder) Build() *UnarchiveLabelsResponse {
	m0 := &UnarchiveLabelsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type ListLabelHistoryResponse_Value struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Commit           *Commit                `protobuf:"bytes,1,opt,name=commit,proto3"`
	xxx_hidden_CommitCheckState *CommitCheckState      `protobuf:"bytes,2,opt,name=commit_check_state,json=commitCheckState,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *ListLabelHistoryResponse_Value) Reset() {
	*x = ListLabelHistoryResponse_Value{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLabelHistoryResponse_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelHistoryResponse_Value) ProtoMessage() {}

func (x *ListLabelHistoryResponse_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListLabelHistoryResponse_Value) GetCommit() *Commit {
	if x != nil {
		return x.xxx_hidden_Commit
	}
	return nil
}

func (x *ListLabelHistoryResponse_Value) GetCommitCheckState() *CommitCheckState {
	if x != nil {
		return x.xxx_hidden_CommitCheckState
	}
	return nil
}

func (x *ListLabelHistoryResponse_Value) SetCommit(v *Commit) {
	x.xxx_hidden_Commit = v
}

func (x *ListLabelHistoryResponse_Value) SetCommitCheckState(v *CommitCheckState) {
	x.xxx_hidden_CommitCheckState = v
}

func (x *ListLabelHistoryResponse_Value) HasCommit() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Commit != nil
}

func (x *ListLabelHistoryResponse_Value) HasCommitCheckState() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CommitCheckState != nil
}

func (x *ListLabelHistoryResponse_Value) ClearCommit() {
	x.xxx_hidden_Commit = nil
}

func (x *ListLabelHistoryResponse_Value) ClearCommitCheckState() {
	x.xxx_hidden_CommitCheckState = nil
}

type ListLabelHistoryResponse_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Commit.
	Commit *Commit
	// The CommitCheckState for this Commit on this Label.
	CommitCheckState *CommitCheckState
}

func (b0 ListLabelHistoryResponse_Value_builder) Build() *ListLabelHistoryResponse_Value {
	m0 := &ListLabelHistoryResponse_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Commit = b.Commit
	x.xxx_hidden_CommitCheckState = b.CommitCheckState
	return m0
}

// An individual request to create or update a Label.
type CreateOrUpdateLabelsRequest_Value struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_LabelRef *LabelRef              `protobuf:"bytes,1,opt,name=label_ref,json=labelRef,proto3"`
	xxx_hidden_CommitId string                 `protobuf:"bytes,2,opt,name=commit_id,json=commitId,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *CreateOrUpdateLabelsRequest_Value) Reset() {
	*x = CreateOrUpdateLabelsRequest_Value{}
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrUpdateLabelsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrUpdateLabelsRequest_Value) ProtoMessage() {}

func (x *CreateOrUpdateLabelsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrUpdateLabelsRequest_Value) GetLabelRef() *LabelRef {
	if x != nil {
		return x.xxx_hidden_LabelRef
	}
	return nil
}

func (x *CreateOrUpdateLabelsRequest_Value) GetCommitId() string {
	if x != nil {
		return x.xxx_hidden_CommitId
	}
	return ""
}

func (x *CreateOrUpdateLabelsRequest_Value) SetLabelRef(v *LabelRef) {
	x.xxx_hidden_LabelRef = v
}

func (x *CreateOrUpdateLabelsRequest_Value) SetCommitId(v string) {
	x.xxx_hidden_CommitId = v
}

func (x *CreateOrUpdateLabelsRequest_Value) HasLabelRef() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_LabelRef != nil
}

func (x *CreateOrUpdateLabelsRequest_Value) ClearLabelRef() {
	x.xxx_hidden_LabelRef = nil
}

type CreateOrUpdateLabelsRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Labels to create or update.
	LabelRef *LabelRef
	// The id of the Commit to associate with the Label.
	//
	// If the Label already existed, the Label will now point to this Commit, as long as this Commit
	// is newer than the Commit that the Label is currently pointing to, otherwise an error is
	// returned.
	// If the Label was archived, it will be unarchived.
	CommitId string
}

func (b0 CreateOrUpdateLabelsRequest_Value_builder) Build() *CreateOrUpdateLabelsRequest_Value {
	m0 := &CreateOrUpdateLabelsRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LabelRef = b.LabelRef
	x.xxx_hidden_CommitId = b.CommitId
	return m0
}

var File_buf_registry_module_v1_label_service_proto protoreflect.FileDescriptor

const file_buf_registry_module_v1_label_service_proto_rawDesc = "" +
	"\n" +
	"*buf/registry/module/v1/label_service.proto\x12\x16buf.registry.module.v1\x1a#buf/registry/module/v1/commit.proto\x1a\"buf/registry/module/v1/label.proto\x1a%buf/registry/module/v1/resource.proto\x1a\x1bbuf/validate/validate.proto\"`\n" +
	"\x10GetLabelsRequest\x12L\n" +
	"\n" +
	"label_refs\x18\x01 \x03(\v2 .buf.registry.module.v1.LabelRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\tlabelRefs\"T\n" +
	"\x11GetLabelsResponse\x12?\n" +
	"\x06labels\x18\x01 \x03(\v2\x1d.buf.registry.module.v1.LabelB\b\xbaH\x05\x92\x01\x02\b\x01R\x06labels\"\xaa\x06\n" +
	"\x11ListLabelsRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12N\n" +
	"\fresource_ref\x18\x03 \x01(\v2#.buf.registry.module.v1.ResourceRefB\x06\xbaH\x03\xc8\x01\x01R\vresourceRef\x12O\n" +
	"\x05order\x18\x04 \x01(\x0e2/.buf.registry.module.v1.ListLabelsRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\x12r\n" +
	"\x15commit_check_statuses\x18\x05 \x03(\x0e2).buf.registry.module.v1.CommitCheckStatusB\x13\xbaH\x10\x92\x01\r\"\v\x82\x01\b\x10\x01\x18\x01\x18\x02\x18\x05R\x13commitCheckStatuses\x12'\n" +
	"\n" +
	"name_query\x18\x06 \x01(\tB\b\xbaH\x05r\x03\x18\xfa\x01R\tnameQuery\x12h\n" +
	"\x0earchive_filter\x18\a \x01(\x0e27.buf.registry.module.v1.ListLabelsRequest.ArchiveFilterB\b\xbaH\x05\x82\x01\x02\x10\x01R\rarchiveFilter\"\x8c\x01\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\x12\x1a\n" +
	"\x16ORDER_UPDATE_TIME_DESC\x10\x03\x12\x19\n" +
	"\x15ORDER_UPDATE_TIME_ASC\x10\x04\"\x8d\x01\n" +
	"\rArchiveFilter\x12\x1e\n" +
	"\x1aARCHIVE_FILTER_UNSPECIFIED\x10\x00\x12\"\n" +
	"\x1eARCHIVE_FILTER_UNARCHIVED_ONLY\x10\x01\x12 \n" +
	"\x1cARCHIVE_FILTER_ARCHIVED_ONLY\x10\x02\x12\x16\n" +
	"\x12ARCHIVE_FILTER_ALL\x10\x03\"}\n" +
	"\x12ListLabelsResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x125\n" +
	"\x06labels\x18\x02 \x03(\v2\x1d.buf.registry.module.v1.LabelR\x06labels\"\xb3\x04\n" +
	"\x17ListLabelHistoryRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12E\n" +
	"\tlabel_ref\x18\x03 \x01(\v2 .buf.registry.module.v1.LabelRefB\x06\xbaH\x03\xc8\x01\x01R\blabelRef\x12U\n" +
	"\x05order\x18\x04 \x01(\x0e25.buf.registry.module.v1.ListLabelHistoryRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\x12l\n" +
	"\x15commit_check_statuses\x18\x05 \x03(\x0e2).buf.registry.module.v1.CommitCheckStatusB\r\xbaH\n" +
	"\x92\x01\a\"\x05\x82\x01\x02\x10\x01R\x13commitCheckStatuses\x123\n" +
	"\x0fstart_commit_id\x18\x06 \x01(\tB\v\xbaH\b\xd8\x01\x01r\x03\x88\x02\x01R\rstartCommitId\x12H\n" +
	"!only_commits_with_changed_digests\x18\a \x01(\bR\x1donlyCommitsWithChangedDigests\"=\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"ORDER_DESC\x10\x01\x12\r\n" +
	"\tORDER_ASC\x10\x02\"\xc6\x02\n" +
	"\x18ListLabelHistoryResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12N\n" +
	"\x06values\x18\x02 \x03(\v26.buf.registry.module.v1.ListLabelHistoryResponse.ValueR\x06values\x1a\xa7\x01\n" +
	"\x05Value\x12>\n" +
	"\x06commit\x18\x01 \x01(\v2\x1e.buf.registry.module.v1.CommitB\x06\xbaH\x03\xc8\x01\x01R\x06commit\x12^\n" +
	"\x12commit_check_state\x18\x02 \x01(\v2(.buf.registry.module.v1.CommitCheckStateB\x06\xbaH\x03\xc8\x01\x01R\x10commitCheckState\"\xf7\x01\n" +
	"\x1bCreateOrUpdateLabelsRequest\x12^\n" +
	"\x06values\x18\x01 \x03(\v29.buf.registry.module.v1.CreateOrUpdateLabelsRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1ax\n" +
	"\x05Value\x12E\n" +
	"\tlabel_ref\x18\x01 \x01(\v2 .buf.registry.module.v1.LabelRefB\x06\xbaH\x03\xc8\x01\x01R\blabelRef\x12(\n" +
	"\tcommit_id\x18\x02 \x01(\tB\v\xbaH\b\xc8\x01\x01r\x03\x88\x02\x01R\bcommitId\"_\n" +
	"\x1cCreateOrUpdateLabelsResponse\x12?\n" +
	"\x06labels\x18\x01 \x03(\v2\x1d.buf.registry.module.v1.LabelB\b\xbaH\x05\x92\x01\x02\b\x01R\x06labels\"d\n" +
	"\x14ArchiveLabelsRequest\x12L\n" +
	"\n" +
	"label_refs\x18\x01 \x03(\v2 .buf.registry.module.v1.LabelRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\tlabelRefs\"\x17\n" +
	"\x15ArchiveLabelsResponse\"f\n" +
	"\x16UnarchiveLabelsRequest\x12L\n" +
	"\n" +
	"label_refs\x18\x01 \x03(\v2 .buf.registry.module.v1.LabelRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\tlabelRefs\"\x19\n" +
	"\x17UnarchiveLabelsResponse2\xd0\x05\n" +
	"\fLabelService\x12e\n" +
	"\tGetLabels\x12(.buf.registry.module.v1.GetLabelsRequest\x1a).buf.registry.module.v1.GetLabelsResponse\"\x03\x90\x02\x01\x12h\n" +
	"\n" +
	"ListLabels\x12).buf.registry.module.v1.ListLabelsRequest\x1a*.buf.registry.module.v1.ListLabelsResponse\"\x03\x90\x02\x01\x12z\n" +
	"\x10ListLabelHistory\x12/.buf.registry.module.v1.ListLabelHistoryRequest\x1a0.buf.registry.module.v1.ListLabelHistoryResponse\"\x03\x90\x02\x01\x12\x86\x01\n" +
	"\x14CreateOrUpdateLabels\x123.buf.registry.module.v1.CreateOrUpdateLabelsRequest\x1a4.buf.registry.module.v1.CreateOrUpdateLabelsResponse\"\x03\x90\x02\x02\x12q\n" +
	"\rArchiveLabels\x12,.buf.registry.module.v1.ArchiveLabelsRequest\x1a-.buf.registry.module.v1.ArchiveLabelsResponse\"\x03\x90\x02\x02\x12w\n" +
	"\x0fUnarchiveLabels\x12..buf.registry.module.v1.UnarchiveLabelsRequest\x1a/.buf.registry.module.v1.UnarchiveLabelsResponse\"\x03\x90\x02\x02BWZUbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/module/v1;modulev1b\x06proto3"

var file_buf_registry_module_v1_label_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_registry_module_v1_label_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_buf_registry_module_v1_label_service_proto_goTypes = []any{
	(ListLabelsRequest_Order)(0),              // 0: buf.registry.module.v1.ListLabelsRequest.Order
	(ListLabelsRequest_ArchiveFilter)(0),      // 1: buf.registry.module.v1.ListLabelsRequest.ArchiveFilter
	(ListLabelHistoryRequest_Order)(0),        // 2: buf.registry.module.v1.ListLabelHistoryRequest.Order
	(*GetLabelsRequest)(nil),                  // 3: buf.registry.module.v1.GetLabelsRequest
	(*GetLabelsResponse)(nil),                 // 4: buf.registry.module.v1.GetLabelsResponse
	(*ListLabelsRequest)(nil),                 // 5: buf.registry.module.v1.ListLabelsRequest
	(*ListLabelsResponse)(nil),                // 6: buf.registry.module.v1.ListLabelsResponse
	(*ListLabelHistoryRequest)(nil),           // 7: buf.registry.module.v1.ListLabelHistoryRequest
	(*ListLabelHistoryResponse)(nil),          // 8: buf.registry.module.v1.ListLabelHistoryResponse
	(*CreateOrUpdateLabelsRequest)(nil),       // 9: buf.registry.module.v1.CreateOrUpdateLabelsRequest
	(*CreateOrUpdateLabelsResponse)(nil),      // 10: buf.registry.module.v1.CreateOrUpdateLabelsResponse
	(*ArchiveLabelsRequest)(nil),              // 11: buf.registry.module.v1.ArchiveLabelsRequest
	(*ArchiveLabelsResponse)(nil),             // 12: buf.registry.module.v1.ArchiveLabelsResponse
	(*UnarchiveLabelsRequest)(nil),            // 13: buf.registry.module.v1.UnarchiveLabelsRequest
	(*UnarchiveLabelsResponse)(nil),           // 14: buf.registry.module.v1.UnarchiveLabelsResponse
	(*ListLabelHistoryResponse_Value)(nil),    // 15: buf.registry.module.v1.ListLabelHistoryResponse.Value
	(*CreateOrUpdateLabelsRequest_Value)(nil), // 16: buf.registry.module.v1.CreateOrUpdateLabelsRequest.Value
	(*LabelRef)(nil),                          // 17: buf.registry.module.v1.LabelRef
	(*Label)(nil),                             // 18: buf.registry.module.v1.Label
	(*ResourceRef)(nil),                       // 19: buf.registry.module.v1.ResourceRef
	(CommitCheckStatus)(0),                    // 20: buf.registry.module.v1.CommitCheckStatus
	(*Commit)(nil),                            // 21: buf.registry.module.v1.Commit
	(*CommitCheckState)(nil),                  // 22: buf.registry.module.v1.CommitCheckState
}
var file_buf_registry_module_v1_label_service_proto_depIdxs = []int32{
	17, // 0: buf.registry.module.v1.GetLabelsRequest.label_refs:type_name -> buf.registry.module.v1.LabelRef
	18, // 1: buf.registry.module.v1.GetLabelsResponse.labels:type_name -> buf.registry.module.v1.Label
	19, // 2: buf.registry.module.v1.ListLabelsRequest.resource_ref:type_name -> buf.registry.module.v1.ResourceRef
	0,  // 3: buf.registry.module.v1.ListLabelsRequest.order:type_name -> buf.registry.module.v1.ListLabelsRequest.Order
	20, // 4: buf.registry.module.v1.ListLabelsRequest.commit_check_statuses:type_name -> buf.registry.module.v1.CommitCheckStatus
	1,  // 5: buf.registry.module.v1.ListLabelsRequest.archive_filter:type_name -> buf.registry.module.v1.ListLabelsRequest.ArchiveFilter
	18, // 6: buf.registry.module.v1.ListLabelsResponse.labels:type_name -> buf.registry.module.v1.Label
	17, // 7: buf.registry.module.v1.ListLabelHistoryRequest.label_ref:type_name -> buf.registry.module.v1.LabelRef
	2,  // 8: buf.registry.module.v1.ListLabelHistoryRequest.order:type_name -> buf.registry.module.v1.ListLabelHistoryRequest.Order
	20, // 9: buf.registry.module.v1.ListLabelHistoryRequest.commit_check_statuses:type_name -> buf.registry.module.v1.CommitCheckStatus
	15, // 10: buf.registry.module.v1.ListLabelHistoryResponse.values:type_name -> buf.registry.module.v1.ListLabelHistoryResponse.Value
	16, // 11: buf.registry.module.v1.CreateOrUpdateLabelsRequest.values:type_name -> buf.registry.module.v1.CreateOrUpdateLabelsRequest.Value
	18, // 12: buf.registry.module.v1.CreateOrUpdateLabelsResponse.labels:type_name -> buf.registry.module.v1.Label
	17, // 13: buf.registry.module.v1.ArchiveLabelsRequest.label_refs:type_name -> buf.registry.module.v1.LabelRef
	17, // 14: buf.registry.module.v1.UnarchiveLabelsRequest.label_refs:type_name -> buf.registry.module.v1.LabelRef
	21, // 15: buf.registry.module.v1.ListLabelHistoryResponse.Value.commit:type_name -> buf.registry.module.v1.Commit
	22, // 16: buf.registry.module.v1.ListLabelHistoryResponse.Value.commit_check_state:type_name -> buf.registry.module.v1.CommitCheckState
	17, // 17: buf.registry.module.v1.CreateOrUpdateLabelsRequest.Value.label_ref:type_name -> buf.registry.module.v1.LabelRef
	3,  // 18: buf.registry.module.v1.LabelService.GetLabels:input_type -> buf.registry.module.v1.GetLabelsRequest
	5,  // 19: buf.registry.module.v1.LabelService.ListLabels:input_type -> buf.registry.module.v1.ListLabelsRequest
	7,  // 20: buf.registry.module.v1.LabelService.ListLabelHistory:input_type -> buf.registry.module.v1.ListLabelHistoryRequest
	9,  // 21: buf.registry.module.v1.LabelService.CreateOrUpdateLabels:input_type -> buf.registry.module.v1.CreateOrUpdateLabelsRequest
	11, // 22: buf.registry.module.v1.LabelService.ArchiveLabels:input_type -> buf.registry.module.v1.ArchiveLabelsRequest
	13, // 23: buf.registry.module.v1.LabelService.UnarchiveLabels:input_type -> buf.registry.module.v1.UnarchiveLabelsRequest
	4,  // 24: buf.registry.module.v1.LabelService.GetLabels:output_type -> buf.registry.module.v1.GetLabelsResponse
	6,  // 25: buf.registry.module.v1.LabelService.ListLabels:output_type -> buf.registry.module.v1.ListLabelsResponse
	8,  // 26: buf.registry.module.v1.LabelService.ListLabelHistory:output_type -> buf.registry.module.v1.ListLabelHistoryResponse
	10, // 27: buf.registry.module.v1.LabelService.CreateOrUpdateLabels:output_type -> buf.registry.module.v1.CreateOrUpdateLabelsResponse
	12, // 28: buf.registry.module.v1.LabelService.ArchiveLabels:output_type -> buf.registry.module.v1.ArchiveLabelsResponse
	14, // 29: buf.registry.module.v1.LabelService.UnarchiveLabels:output_type -> buf.registry.module.v1.UnarchiveLabelsResponse
	24, // [24:30] is the sub-list for method output_type
	18, // [18:24] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_label_service_proto_init() }
func file_buf_registry_module_v1_label_service_proto_init() {
	if File_buf_registry_module_v1_label_service_proto != nil {
		return
	}
	file_buf_registry_module_v1_commit_proto_init()
	file_buf_registry_module_v1_label_proto_init()
	file_buf_registry_module_v1_resource_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_module_v1_label_service_proto_rawDesc), len(file_buf_registry_module_v1_label_service_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1_label_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_label_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1_label_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1_label_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_label_service_proto = out.File
	file_buf_registry_module_v1_label_service_proto_goTypes = nil
	file_buf_registry_module_v1_label_service_proto_depIdxs = nil
}
